package com.biz.crm.mdm.business.position.level.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.position.level.feign.feign.internal.PositionLevelVoServiceFeignImpl;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 职位级别管理feign
 *
 * @author ning.zhang
 * @date 2022/5/6
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = PositionLevelVoServiceFeignImpl.class)
public interface PositionLevelVoServiceFeign {

  /**
   * 职位级别分页列表
   *
   * @param dto  请求参数dto
   * @param page 页数
   * @param size 分页大小
   * @return Page<PositionLevelVo> 职位级别分页信息
   */
  @GetMapping("/v1/positionLevel/positionLevel/findByConditions")
  Result<Page<PositionLevelVo>> findByConditions(@RequestParam("page") Integer page,
                                                 @RequestParam("size") Integer size,
                                                 @SpringQueryMap PositionLevelDto dto);

  /**
   * 根据id查询编辑职位级别详情
   *
   * @param id 职位级别ID
   * @return 职位级别信息
   */
  @GetMapping("/v1/positionLevel/positionLevel/findById")
  Result<PositionLevelVo> findById(@RequestParam("id") String id);

  /**
   * 根据职位级别ID集合或者code集合查询职位级别列表
   *
   * @param ids                职位级别ID集合
   * @param positionLevelCodes 职位级别编码集合
   * @return 职位级别列表
   */
  @GetMapping("/v1/positionLevel/positionLevel/findByIdsOrCodes")
  Result<List<PositionLevelVo>> findByIdsOrCodes(@RequestParam("ids") List<String> ids, @RequestParam("positionLevelCodes") List<String> positionLevelCodes);
}
