package com.biz.crm.mdm.business.position.level.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.position.level.feign.feign.PositionLevelVoServiceFeign;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import com.biz.crm.mdm.business.position.level.sdk.service.PositionLevelVoService;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * 职位级别sdk接口实现
 *
 * @author ning.zhang
 * @date 2022/5/6
 */
@Service
public class PositionLevelVoServiceImpl implements PositionLevelVoService {

  @Autowired(required = false)
  private PositionLevelVoServiceFeign positionLevelVoServiceFeign;

  @Override
  public Page<PositionLevelVo> findByConditions(Pageable pageable, PositionLevelDto dto) {
    return this.positionLevelVoServiceFeign.findByConditions(pageable.getPageNumber(), pageable.getPageSize(), dto).getResult();
  }

  @Override
  public PositionLevelVo findById(String id) {
    return this.positionLevelVoServiceFeign.findById(id).getResult();
  }

  @Override
  public List<PositionLevelVo> findByIdsOrCodes(List<String> ids, List<String> positionLevelCodes) {
    return this.positionLevelVoServiceFeign.findByIdsOrCodes(ids,positionLevelCodes).getResult();
  }

  @Override
  public String createPositionNameByPositionLevelCode(String positionLevelCode, Set<String> positionNameSet, String tenantCode) {
    throw new UnsupportedOperationException();
  }
}
