package com.biz.crm.mdm.business.position.level.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 职位级别-角色关联表实体类
 *
 * @author ning.zhang
 * @date 2021/9/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PositionLevelRoleEntity", description = "职位级别-角色关联表实体别实体")
@Entity
@TableName("mdm_position_level_role")
@Table(name = "mdm_position_level_role", indexes = {
    @Index(name = "position_level_role_index1", columnList = "position_level_code"),
    @Index(name = "position_level_role_index2", columnList = "role_code"),
    @Index(name = "position_level_role_index3", columnList = "tenant_code,role_code,position_level_code",unique = true)
})
@org.hibernate.annotations.Table(appliesTo = "mdm_position_level_role", comment = "职位级别-角色关联表")
public class PositionLevelRoleEntity extends TenantEntity {

  private static final long serialVersionUID = 3692608742763047362L;

  /**
   * 职位级别编码
   */
  @ApiModelProperty(name = "position_level_code", value = "职位级别编码", required = true)
  @Column(name = "position_level_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '职位级别编码'")
  private String positionLevelCode;

  /**
   * 角色编码
   */
  @ApiModelProperty(name = "role_code", value = "角色编码", required = true)
  @Column(name = "role_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '角色编码'")
  private String roleCode;

}
