/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.level.local.repository;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.position.level.local.entity.PositionLevelEntity;
import com.biz.crm.mdm.business.position.level.local.mapper.PositionLevelMapper;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class PositionLevelRepository
extends ServiceImpl<PositionLevelMapper, PositionLevelEntity> {
    @Autowired(required=false)
    private PositionLevelMapper positionLevelMapper;

    public Page<PositionLevelEntity> findByConditions(Pageable pageable, PositionLevelDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((PositionLevelMapper)this.baseMapper).findByConditions((Page<PositionLevelEntity>)page, dto);
    }

    public List<PositionLevelEntity> findByIdsOrCodes(List<String> ids, List<String> positionLevelCodes, String tenantCode) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ids.removeIf(Objects::isNull);
        }
        if (CollectionUtils.isNotEmpty(positionLevelCodes)) {
            positionLevelCodes.removeIf(Objects::isNull);
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(CollectionUtils.isNotEmpty(ids), UuidEntity::getId, ids)).in(CollectionUtils.isNotEmpty(positionLevelCodes), PositionLevelEntity::getPositionLevelCode, positionLevelCodes)).list();
    }

    public List<PositionLevelEntity> findByCodeIn(List<String> positionLevelCodeList, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(PositionLevelEntity::getPositionLevelCode, positionLevelCodeList)).select(new SFunction[]{PositionLevelEntity::getPositionLevelCode}).list();
    }

    public List<PositionLevelEntity> findByName(String positionLevelName, String tenantCode) {
        return this.positionLevelMapper.findByName(positionLevelName, tenantCode);
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateSuffixSequenceById(Integer suffixSequence, String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidEntity::getId, (Object)id)).set(PositionLevelEntity::getSuffixSequence, (Object)suffixSequence)).update();
    }

    public List<PositionLevelEntity> findByRoleCodes(List<String> roleCodes, String tenantCode) {
        return ((PositionLevelMapper)this.baseMapper).findByRoleCodes(roleCodes, tenantCode);
    }
}

