/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.level.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.position.level.local.entity.PositionLevelEntity;
import com.biz.crm.mdm.business.position.level.local.entity.PositionLevelRoleEntity;
import com.biz.crm.mdm.business.position.level.local.service.PositionLevelRoleService;
import com.biz.crm.mdm.business.position.level.local.service.PositionLevelService;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import com.biz.crm.mdm.business.position.level.sdk.service.PositionLevelVoService;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PositionLevelVoServiceImpl
implements PositionLevelVoService {
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private PositionLevelRoleService positionLevelRoleService;
    @Autowired(required=false)
    private PositionLevelService positionLevelService;
    @Autowired(required=false)
    private RoleVoCacheService roleVoCacheService;

    public Page<PositionLevelVo> findByConditions(Pageable pageable, PositionLevelDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (PositionLevelDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new PositionLevelDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<PositionLevelEntity> entityPage = this.positionLevelService.findByConditions(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)entityPage.getRecords())) {
            pageResult.setRecords(this.convertEntityToVo(entityPage.getRecords()));
        }
        return pageResult;
    }

    public PositionLevelVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        List<PositionLevelEntity> entities = this.positionLevelService.findByIdsOrCodes(Lists.newArrayList((Object[])new String[]{id}), null);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        return this.convertEntityToVo(Lists.newArrayList(entities)).get(0);
    }

    public List<PositionLevelVo> findByIdsOrCodes(List<String> ids, List<String> positionLevelCodes) {
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(positionLevelCodes)) {
            return Lists.newArrayList();
        }
        List<PositionLevelEntity> entities = this.positionLevelService.findByIdsOrCodes(ids, positionLevelCodes);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        return this.convertEntityToVo(entities);
    }

    @Transactional
    public String createPositionNameByPositionLevelCode(String positionLevelCode, Set<String> positionNameSet, String tenantCode) {
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801", (Object[])new Object[0]);
        List<PositionLevelEntity> entities = this.positionLevelService.findByIdsOrCodes(null, Lists.newArrayList((Object[])new String[]{positionLevelCode}));
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7ea7\u522b", (Object[])new Object[0]);
        PositionLevelEntity positionLevel = entities.get(0);
        Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(positionLevel.getEnableStatus()), (String)"\u8be5\u804c\u4f4d\u7ea7\u522b\u5df2\u505c\u7528", (Object[])new Object[0]);
        Integer suffixSequence = positionLevel.getSuffixSequence();
        if (suffixSequence == null) {
            suffixSequence = 0;
        }
        suffixSequence = suffixSequence + 1;
        String positionName = positionLevel.getPositionLevelName() + "_" + suffixSequence;
        while (!CollectionUtils.isEmpty(positionNameSet) && positionNameSet.contains(positionName)) {
            suffixSequence = suffixSequence + 1;
            positionName = positionLevel.getPositionLevelName() + "_" + suffixSequence;
        }
        this.positionLevelService.updateSuffixSequenceById(suffixSequence, positionLevel.getId());
        return positionName;
    }

    private List<PositionLevelVo> convertEntityToVo(List<PositionLevelEntity> entities) {
        ArrayList list = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, PositionLevelEntity.class, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
        List<String> positionLevelCodes = list.stream().map(PositionLevelVo::getPositionLevelCode).collect(Collectors.toList());
        List<PositionLevelRoleEntity> positionRoles = this.positionLevelRoleService.findByPositionLevelCodes(positionLevelCodes);
        if (CollectionUtils.isNotEmpty(positionRoles)) {
            Map positionRoleMap = positionRoles.stream().collect(Collectors.groupingBy(PositionLevelRoleEntity::getPositionLevelCode, Collectors.mapping(PositionLevelRoleEntity::getRoleCode, Collectors.toList())));
            Set roleCodes = positionRoleMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            Set roleVoSet = this.roleVoCacheService.findByTenantCodeAndRoleCodes(TenantUtils.getTenantCode(), roleCodes);
            Map<Object, Object> roleNameMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)roleVoSet)) {
                roleNameMap = roleVoSet.stream().collect(Collectors.toMap(RoleVo::getRoleCode, RoleVo::getRoleName, (key1, key2) -> key1));
            }
            for (PositionLevelVo positionLevelVo : list) {
                List roleCodeList = positionRoleMap.get(positionLevelVo.getPositionLevelCode());
                if (CollectionUtils.isEmpty(roleCodeList)) continue;
                List roleNames = roleCodeList.stream().map(roleNameMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                positionLevelVo.setRoleList(roleCodeList);
                positionLevelVo.setRoleCode(String.join((CharSequence)",", positionLevelVo.getRoleList()));
                if (!CollectionUtils.isNotEmpty(roleNames)) continue;
                positionLevelVo.setRoleName(String.join((CharSequence)",", roleNames));
            }
        }
        return list;
    }
}

