package com.biz.crm.mdm.business.position.level.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 职位级别实体类
 *
 * @author ning.zhang
 * @date 2021/9/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PositionLevelEntity", description = "职位级别实体")
@Entity
@TableName("mdm_position_level")
@Table(name = "mdm_position_level", indexes = {
    @Index(name = "mdm_position_level_index1", columnList = "tenant_code,position_level_code",unique = true),
    @Index(name = "mdm_position_level_index2", columnList = "position_level_code"),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_position_level", comment = "职位级别表")
public class PositionLevelEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 6042706620069994369L;

  /**
   * 职位级别编码
   */
  @ApiModelProperty(name = "position_level_code", value = "职位级别编码", required = true)
  @Column(name = "position_level_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '职位级别编码'")
  private String positionLevelCode;

  /**
   * 职位级别名称
   */
  @ApiModelProperty(name = "position_level_name", value = "职位级别名称", required = true)
  @Column(name = "position_level_name", length = 128, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '职位级别名称'")
  private String positionLevelName;

  /**
   * 职位级别生成职位名称后缀增长序列号
   */
  @ApiModelProperty(name = "suffix_sequence", value = "职位级别生成职位名称后缀增长序列号")
  @Column(name = "suffix_sequence", length = 10, columnDefinition = "INT(10) NOT NULL COMMENT '职位级别生成职位名称后缀增长序列号'")
  private Integer suffixSequence;

}
