package com.biz.crm.mdm.business.position.level.local.service;

import com.biz.crm.mdm.business.position.level.local.entity.PositionLevelRoleEntity;

import java.util.List;

/**
 * 职位级别-角色关联表接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
public interface PositionLevelRoleService {

  /**
   * 替换职位级别关联的角色
   *
   * @param positionLevelCode 职位级别编码
   * @param roleCodes         角色编码
   */
  void rebindByPositionLevelCodeAndRoleCodes(String positionLevelCode, List<String> roleCodes);

  /**
   * 添加职位级别关联的角色
   *
   * @param positionLevelCode 职位级别编码
   * @param roleCodes         角色编码集合
   */
  void bindByPositionLevelCodeAndRoleCodes(String positionLevelCode, List<String> roleCodes);

  /**
   * 移除职位级别关联的角色
   *
   * @param positionLevelCode 职位级别编码
   */
  void unbindByPositionLevelCode(String positionLevelCode);

  /**
   * 批量移除职位级别关联的角色
   *
   * @param positionLevelCodes 职位级别编码集合
   */
  void unbindByPositionLevelCodeIn(List<String> positionLevelCodes);

  /**
   * 移除角色编码关联职位级别
   *
   * @param roleCode 角色编码
   */
  void unbindByRoleCode(String roleCode);

  /**
   * 批量移除角色编码关联职位级别
   *
   * @param roleCodes 角色编码集合
   */
  void unbindByRoleCodeIn(List<String> roleCodes);

  /**
   * 通过职位级别编码集合获取职位级别角色关联实体列表
   *
   * @param positionLevelCodes 职位级别编码集合
   * @return 职位级别角色关联列表
   */
  List<PositionLevelRoleEntity> findByPositionLevelCodes(List<String> positionLevelCodes);

  /**
   * 通过角色编码集合获取职位级别角色关联实体列表
   *
   * @param roleCodes 角色编码集合
   * @return 职位级别角色关联实体列表
   */
  List<PositionLevelRoleEntity> findByRoleCodes(List<String> roleCodes);
}

