package com.biz.crm.mdm.business.position.level.local.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.position.level.local.service.PositionLevelService;
import com.biz.crm.mdm.business.position.level.sdk.deprecated.dto.MdmPositionLevelDto;
import com.biz.crm.mdm.business.position.level.sdk.deprecated.vo.MdmPositionLevelVo;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import com.biz.crm.mdm.business.position.level.sdk.service.PositionLevelVoService;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 旧版职位级别-接口
 *
 * @author ning.zhang
 * @date 2021/9/30
 */
@Slf4j
@RestController
@RequestMapping("/mdmPositionLevelController")
@Api(tags = "旧版MDM-职位级别")
@Deprecated
public class MdmPositionLevelController {

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private PositionLevelVoService positionLevelVoService;
  @Autowired(required = false)
  private PositionLevelService positionLevelService;

  @ApiOperation(value = "查询职位级别列表（分页）")
  @PostMapping("/pageList")
  @Deprecated
  public Result<Page<MdmPositionLevelVo>> findByConditions(@RequestBody MdmPositionLevelDto mdmDto) {
    try {
      mdmDto = ObjectUtils.defaultIfNull(mdmDto, new MdmPositionLevelDto());
      Pageable pageable = PageRequest.of(mdmDto.getPageNum(), mdmDto.getPageSize());
      PositionLevelDto dto = nebulaToolkitService.copyObjectByWhiteList(mdmDto, PositionLevelDto.class, HashSet.class, ArrayList.class);
      Page<PositionLevelVo> page = positionLevelVoService.findByConditions(pageable, dto);
      Page<MdmPositionLevelVo> mdmPage = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
      if (CollectionUtils.isNotEmpty(page.getRecords())) {
        mdmPage.setRecords(Lists.newArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(page.getRecords()
            , PositionLevelVo.class, MdmPositionLevelVo.class, HashSet.class, ArrayList.class)));
      }
      return Result.ok(mdmPage);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情(编辑页面使用)", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "query")
  })
  @GetMapping("/queryForUpdate")
  @Deprecated
  public Result<MdmPositionLevelVo> findById(@RequestParam(value = "id", required = false) String id) {
    try {
      MdmPositionLevelVo mdmVo = null;
      PositionLevelVo vo = positionLevelVoService.findById(id);
      if (vo != null) {
        mdmVo = nebulaToolkitService.copyObjectByWhiteList(vo, MdmPositionLevelVo.class, HashSet.class, ArrayList.class);
      }
      return Result.ok(mdmVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
      @ApiImplicitParam(name = "positionLevelCode", value = "职位级别编码", required = false, dataType = "String", paramType = "query")
  })
  @GetMapping("/detail")
  @Deprecated
  public Result<MdmPositionLevelVo> findByIdOrCode(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "positionLevelCode", required = false) String positionLevelCode) {
    try {
      MdmPositionLevelVo mdmVo = null;
      List<PositionLevelVo> vos = positionLevelVoService.findByIdsOrCodes(Lists.newArrayList(id), Lists.newArrayList(positionLevelCode));
      if (CollectionUtils.isNotEmpty(vos)) {
        mdmVo = nebulaToolkitService.copyObjectByWhiteList(vos.get(0), MdmPositionLevelVo.class, HashSet.class, ArrayList.class);
      }
      return Result.ok(mdmVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "新增职位级别")
  @PostMapping("/save")
  @Deprecated
  public Result<?> create(@RequestBody MdmPositionLevelDto mdmDto) {
    try {
      mdmDto = ObjectUtils.defaultIfNull(mdmDto, new MdmPositionLevelDto());
      PositionLevelDto dto = nebulaToolkitService.copyObjectByWhiteList(mdmDto, PositionLevelDto.class, HashSet.class, ArrayList.class);
      positionLevelService.create(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "根据id更新职位级别")
  @PostMapping("/update")
  @Deprecated
  public Result<?> update(@RequestBody MdmPositionLevelDto mdmDto) {
    try {
      mdmDto = ObjectUtils.defaultIfNull(mdmDto, new MdmPositionLevelDto());
      PositionLevelDto dto = nebulaToolkitService.copyObjectByWhiteList(mdmDto, PositionLevelDto.class, HashSet.class, ArrayList.class);
      positionLevelService.update(dto);
      return Result.ok("修改成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  @Deprecated
  public Result<?> deleteBatch(@RequestBody List<String> ids) {
    try {
      positionLevelService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "启用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/enable")
  @Deprecated
  public Result<?> enableBatch(@RequestBody List<String> ids) {
    try {
      positionLevelService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "禁用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/disable")
  @Deprecated
  public Result<?> disableBatch(@RequestBody List<String> ids) {
    try {
      positionLevelService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
