/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.level.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.position.level.local.service.PositionLevelService;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/positionLevel/positionLevel"})
@Api(tags={"\u804c\u4f4d\u7ba1\u7406: PositionLevel: \u804c\u4f4d\u7ea7\u522b"})
public class PositionLevelController {
    private static final Logger log = LoggerFactory.getLogger(PositionLevelController.class);
    @Autowired(required=false)
    private PositionLevelService positionLevelService;

    @ApiOperation(value="\u521b\u5efa\u804c\u4f4d\u7ea7\u522b")
    @PostMapping(value={"/create"})
    public Result<?> create(@RequestBody PositionLevelDto positionLevelDto) {
        try {
            return Result.ok((Object)((Object)this.positionLevelService.create(positionLevelDto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f")
    @PatchMapping(value={"/update"})
    public Result<?> update(@RequestBody PositionLevelDto positionLevelDto) {
        try {
            return Result.ok((Object)((Object)this.positionLevelService.update(positionLevelDto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f,\u901a\u8fc7\u4e3b\u952e\u96c6\u5408\u8fdb\u884c\u6570\u636e\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.positionLevelService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u542f\u7528\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f,\u901a\u8fc7\u4e3b\u952e\u96c6\u5408\u8fdb\u884c\u6570\u636e\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result<?> enableBatch(@RequestBody List<String> ids) {
        try {
            this.positionLevelService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u7981\u7528\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f,\u901a\u8fc7\u4e3b\u952e\u96c6\u5408\u8fdb\u884c\u6570\u636e\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result<?> disableBatch(@RequestBody List<String> ids) {
        try {
            this.positionLevelService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

