/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.level.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.mdm.business.position.level.local.entity.PositionLevelRoleEntity;
import com.biz.crm.mdm.business.position.level.local.mapper.PositionLevelRoleMapper;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class PositionLevelRoleRepository
extends ServiceImpl<PositionLevelRoleMapper, PositionLevelRoleEntity> {
    public List<PositionLevelRoleEntity> findByPositionLevelCodeIn(List<String> positionLevelCodeList, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)super.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(PositionLevelRoleEntity::getPositionLevelCode, positionLevelCodeList)).list();
    }

    public List<PositionLevelRoleEntity> findByPositionLevelCode(String positionLevelCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)super.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(PositionLevelRoleEntity::getPositionLevelCode, (Object)positionLevelCode)).list();
    }

    public List<PositionLevelRoleEntity> findByLevelCodeAndRoleCodeIn(String positionLevelCode, List<String> roleCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)super.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(PositionLevelRoleEntity::getPositionLevelCode, (Object)positionLevelCode)).in(PositionLevelRoleEntity::getRoleCode, roleCodes)).list();
    }

    public void deleteByLevelCodeIn(List<String> positionLevelCodeList, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(PositionLevelRoleEntity::getPositionLevelCode, positionLevelCodeList)).remove();
    }

    public void deleteByRoleCodeIn(List<String> roleCodes, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(PositionLevelRoleEntity::getRoleCode, roleCodes)).remove();
    }

    public List<PositionLevelRoleEntity> findByRoleCodes(List<String> roleCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)super.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(PositionLevelRoleEntity::getRoleCode, roleCodes)).list();
    }
}

