package com.biz.crm.mdm.business.position.level.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.position.level.local.service.PositionLevelService;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 职位管理: PositionLevel: 职位级别
 *
 * @author ning.zhang
 * @date 2021/9/30
 */
@Slf4j
@RestController
@RequestMapping("/v1/positionLevel/positionLevel")
@Api(tags = "职位管理: PositionLevel: 职位级别")
public class PositionLevelController {

  @Autowired(required = false)
  private PositionLevelService positionLevelService;

  @ApiOperation(value = "创建职位级别")
  @PostMapping("/create")
  public Result<?> create(@RequestBody PositionLevelDto positionLevelDto) {
    try {
      return Result.ok(positionLevelService.create(positionLevelDto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新职位级别信息")
  @PatchMapping("/update")
  public Result<?> update(@RequestBody PositionLevelDto positionLevelDto) {
    try {
      return Result.ok(positionLevelService.update(positionLevelDto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "批量删除职位级别信息,通过主键集合进行数据删除")
  @DeleteMapping("/deleteBatch")
  public Result<?> deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      positionLevelService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "批量启用职位级别信息,通过主键集合进行数据启用")
  @PatchMapping("/enableBatch")
  public Result<?> enableBatch(@RequestBody List<String> ids) {
    try {
      positionLevelService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "批量禁用职位级别信息,通过主键集合进行数据禁用")
  @PatchMapping("/disableBatch")
  public Result<?> disableBatch(@RequestBody List<String> ids) {
    try {
      positionLevelService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
