package com.biz.crm.mdm.business.position.level.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.position.level.local.entity.PositionLevelEntity;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 职位级别接口
 *
 * @author ning.zhang
 * @date 2021/9/28
 */
public interface PositionLevelService {

  /**
   * 创建职位级别
   *
   * @param dto 请求参数dto
   * @return 新建实体
   */
  PositionLevelEntity create(PositionLevelDto dto);

  /**
   * 更新职位级别
   *
   * @param dto 请求参数dto
   * @return 更新实体
   */
  PositionLevelEntity update(PositionLevelDto dto);

  /**
   * 批量删除职位级别
   *
   * @param ids 职位级别id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用职位级别
   *
   * @param ids 职位级别id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用职位级别
   *
   * @param ids 职位级别id集合
   */
  void disableBatch(List<String> ids);

  /**
   * 职位级别分页列表
   *
   * @param pageable 分页信息
   * @param dto      分页参数dto
   * @return 分页列表
   */
  Page<PositionLevelEntity> findByConditions(Pageable pageable, PositionLevelDto dto);

  /**
   * 根据职位级别ID集合或者code集合查询职位级别列表
   *
   * @param ids                职位级别ID集合
   * @param positionLevelCodes 职位级别编码集合
   * @return 职位级别列表
   */
  List<PositionLevelEntity> findByIdsOrCodes(List<String> ids, List<String> positionLevelCodes);

  /**
   * 更新职位名称后缀增长序列号
   *
   * @param suffixSequence 职位名称后缀增长序列号
   * @param id             职位级别Id
   */
  void updateSuffixSequenceById(Integer suffixSequence, String id);

  /**
   * 通过角色编码集合获取职位级别信息
   *
   * @param roleCodes  角色编码集合
   * @param tenantCode 租户编码
   * @return 职位级别实体集合
   */
  List<PositionLevelEntity> findByRoleCodes(List<String> roleCodes, String tenantCode);
}

