package com.biz.crm.mdm.business.position.level.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.position.level.local.entity.PositionLevelEntity;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 职位级别的mybatis-plus接口类 {@link PositionLevelEntity}
 *
 * @author ning.zhang
 * @date 2021/9/28
 */
public interface PositionLevelMapper extends BaseMapper<PositionLevelEntity> {

  /**
   * 职位级别分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<PositionLevelEntity> findByConditions(@Param("page") Page<PositionLevelEntity> page, @Param("dto") PositionLevelDto dto);

  /**
   * 查询相同职级名称的数据个数
   *
   * @param positionLevelName 职级名称
   * @param tenantCode        租户编码
   * @return 相同职级名称的职位级别列表
   */
  List<PositionLevelEntity> findByName(@Param("positionLevelName") String positionLevelName, @Param("tenantCode") String tenantCode);

  /**
   * 通过角色编码集合获取职位级别信息
   *
   * @param roleCodes  角色编码集合
   * @param tenantCode 租户编码
   * @return 职位级别实体集合
   */
  List<PositionLevelEntity> findByRoleCodes(@Param("roleCodes") List<String> roleCodes, @Param("tenantCode") String tenantCode);
}
