/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.level.local.service.internal;

import com.biz.crm.mdm.business.position.level.local.entity.PositionLevelRoleEntity;
import com.biz.crm.mdm.business.position.level.local.repository.PositionLevelRoleRepository;
import com.biz.crm.mdm.business.position.level.local.service.PositionLevelRoleService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PositionLevelRoleServiceImpl
implements PositionLevelRoleService {
    @Autowired(required=false)
    private PositionLevelRoleRepository positionLevelRoleRepository;
    @Autowired(required=false)
    private RoleVoCacheService roleVoCacheService;

    @Override
    @Transactional
    public void rebindByPositionLevelCodeAndRoleCodes(String positionLevelCode, List<String> roleCodes) {
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        this.unbindByPositionLevelCode(positionLevelCode);
        if (CollectionUtils.isNotEmpty(roleCodes)) {
            return;
        }
        List roleEntities = roleCodes.stream().filter(StringUtils::isNotEmpty).map(roleCode -> {
            PositionLevelRoleEntity entity = new PositionLevelRoleEntity();
            entity.setPositionLevelCode(positionLevelCode);
            entity.setRoleCode((String)roleCode);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(roleEntities)) {
            this.positionLevelRoleRepository.saveBatch(roleEntities);
            roleCodes.forEach(roleCode -> this.roleVoCacheService.clearCache(tenantCode, roleCode));
        }
    }

    @Override
    @Transactional
    public void bindByPositionLevelCodeAndRoleCodes(String positionLevelCode, List<String> roleCodes) {
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        if (CollectionUtils.isEmpty(roleCodes)) {
            return;
        }
        List<PositionLevelRoleEntity> list = this.positionLevelRoleRepository.findByLevelCodeAndRoleCodeIn(positionLevelCode, roleCodes, tenantCode);
        ArrayList existList = CollectionUtils.isNotEmpty(list) ? list.stream().map(PositionLevelRoleEntity::getRoleCode).collect(Collectors.toList()) : Lists.newArrayList();
        List roleEntities = roleCodes.stream().filter(x -> !existList.contains(x)).map(roleCode -> {
            PositionLevelRoleEntity entity = new PositionLevelRoleEntity();
            entity.setRoleCode((String)roleCode);
            entity.setPositionLevelCode(positionLevelCode);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(roleEntities)) {
            this.positionLevelRoleRepository.saveBatch(roleEntities);
            roleCodes.forEach(roleCode -> this.roleVoCacheService.clearCache(tenantCode, roleCode));
        }
    }

    @Override
    @Transactional
    public void unbindByPositionLevelCode(String positionLevelCode) {
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.unbindByPositionLevelCodeIn(Lists.newArrayList((Object[])new String[]{positionLevelCode}));
    }

    @Override
    @Transactional
    public void unbindByPositionLevelCodeIn(List<String> positionLevelCodes) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(positionLevelCodes), (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List<PositionLevelRoleEntity> entities = this.positionLevelRoleRepository.findByPositionLevelCodeIn(positionLevelCodes, tenantCode);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.positionLevelRoleRepository.deleteByLevelCodeIn(positionLevelCodes, tenantCode);
        entities.forEach(entity -> this.roleVoCacheService.clearCache(tenantCode, entity.getRoleCode()));
    }

    @Override
    @Transactional
    public void unbindByRoleCode(String roleCode) {
        Validate.notBlank((CharSequence)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.unbindByRoleCodeIn(Lists.newArrayList((Object[])new String[]{roleCode}));
    }

    @Override
    @Transactional
    public void unbindByRoleCodeIn(List<String> roleCodes) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(roleCodes), (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        this.positionLevelRoleRepository.deleteByRoleCodeIn(roleCodes, tenantCode);
        roleCodes.forEach(roleCode -> this.roleVoCacheService.clearCache(tenantCode, roleCode));
    }

    @Override
    public List<PositionLevelRoleEntity> findByPositionLevelCodes(List<String> positionLevelCodes) {
        if (CollectionUtils.isEmpty(positionLevelCodes)) {
            return Lists.newArrayList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.positionLevelRoleRepository.findByPositionLevelCodeIn(positionLevelCodes, tenantCode);
    }

    @Override
    public List<PositionLevelRoleEntity> findByRoleCodes(List<String> roleCodes) {
        if (CollectionUtils.isEmpty(roleCodes)) {
            return Lists.newArrayList();
        }
        return this.positionLevelRoleRepository.findByRoleCodes(roleCodes, TenantUtils.getTenantCode());
    }
}

