/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.level.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.position.level.local.entity.PositionLevelEntity;
import com.biz.crm.mdm.business.position.level.local.repository.PositionLevelRepository;
import com.biz.crm.mdm.business.position.level.local.service.PositionLevelRoleService;
import com.biz.crm.mdm.business.position.level.local.service.PositionLevelService;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelLogDto;
import com.biz.crm.mdm.business.position.level.sdk.event.PositionLevelEventListener;
import com.biz.crm.mdm.business.position.level.sdk.event.PositionLevelLogEventListener;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PositionLevelServiceImpl
implements PositionLevelService {
    @Autowired(required=false)
    @Lazy
    private List<PositionLevelEventListener> listeners;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private PositionLevelRepository positionLevelRepository;
    @Autowired(required=false)
    private PositionLevelRoleService positionLevelRoleService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    @Transactional
    public PositionLevelEntity create(PositionLevelDto dto) {
        this.createValidation(dto);
        PositionLevelEntity entity = (PositionLevelEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, PositionLevelEntity.class, HashSet.class, ArrayList.class, new String[0]));
        if (StringUtils.isEmpty((CharSequence)entity.getPositionLevelCode())) {
            entity.setPositionLevelCode((String)this.generateCodeService.generateCode("ZWJB", 1).get(0));
        }
        List<PositionLevelEntity> list = this.positionLevelRepository.findByCodeIn(Lists.newArrayList((Object[])new String[]{entity.getPositionLevelCode()}), dto.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        entity.setSuffixSequence(0);
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.positionLevelRepository.save((Object)entity);
        if (StringUtils.isNotEmpty((CharSequence)dto.getRoleCode())) {
            this.positionLevelRoleService.bindByPositionLevelCodeAndRoleCodes(entity.getPositionLevelCode(), Arrays.asList(dto.getRoleCode().split(",")));
        }
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            PositionLevelVo vo = (PositionLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(eventListener -> eventListener.onCreate(vo));
        }
        PositionLevelLogDto positionLevelLogDto = new PositionLevelLogDto();
        positionLevelLogDto.setNewest((PositionLevelDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PositionLevelDto.class, HashSet.class, ArrayList.class, new String[0]));
        SerializableBiConsumer & Serializable onCreate = PositionLevelLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)positionLevelLogDto, PositionLevelLogEventListener.class, (SerializableBiConsumer)onCreate);
        return entity;
    }

    @Override
    @Transactional
    public PositionLevelEntity update(PositionLevelDto dto) {
        this.updateValidation(dto);
        PositionLevelEntity entity = this.positionLevelRepository.findByIdAndTenantCode(dto.getId(), dto.getTenantCode());
        PositionLevelDto oldDto = (PositionLevelDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PositionLevelDto.class, HashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)((Object)entity), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)entity.getPositionLevelCode().equals(dto.getPositionLevelCode()), (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        Validate.isTrue((boolean)entity.getTenantCode().equals(dto.getTenantCode()), (String)"\u79df\u6237\u7f16\u7801\u4e0d\u5339\u914d", (Object[])new Object[0]);
        PositionLevelVo oldVo = (PositionLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
        entity.setPositionLevelName(dto.getPositionLevelName());
        entity.setEnableStatus(dto.getEnableStatus());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.positionLevelRepository.updateByIdAndTenantCode(entity, TenantUtils.getTenantCode());
        this.positionLevelRoleService.unbindByPositionLevelCode(entity.getPositionLevelCode());
        if (StringUtils.isNotEmpty((CharSequence)dto.getRoleCode())) {
            this.positionLevelRoleService.bindByPositionLevelCodeAndRoleCodes(entity.getPositionLevelCode(), Arrays.asList(dto.getRoleCode().split(",")));
        }
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            PositionLevelVo newVo = (PositionLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(eventListener -> eventListener.onUpdate(oldVo, newVo));
        }
        PositionLevelLogDto positionLevelLogDto = new PositionLevelLogDto();
        positionLevelLogDto.setNewest(dto);
        positionLevelLogDto.setOriginal(oldDto);
        SerializableBiConsumer & Serializable onUpdate = PositionLevelLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)positionLevelLogDto, PositionLevelLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return entity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<PositionLevelEntity> entities = this.positionLevelRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((CollectionUtils.isNotEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        List<String> positionLevelCodeList = entities.stream().map(PositionLevelEntity::getPositionLevelCode).collect(Collectors.toList());
        this.positionLevelRoleService.unbindByPositionLevelCodeIn(positionLevelCodeList);
        this.positionLevelRepository.updateDelFlagByIds(ids);
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, PositionLevelEntity.class, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(eventListener -> eventListener.onDelete(voList));
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<PositionLevelEntity> entities = this.positionLevelRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((CollectionUtils.isNotEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.positionLevelRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, PositionLevelEntity.class, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(eventListener -> eventListener.onEnable(voList));
        }
        for (PositionLevelEntity entity : entities) {
            PositionLevelDto oldDto = new PositionLevelDto();
            PositionLevelDto newDto = new PositionLevelDto();
            oldDto.setId(entity.getId());
            oldDto.setEnableStatus(entity.getEnableStatus());
            newDto.setId(entity.getId());
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            PositionLevelLogDto positionLevelLogDto = new PositionLevelLogDto();
            positionLevelLogDto.setNewest(newDto);
            positionLevelLogDto.setOriginal(oldDto);
            SerializableBiConsumer & Serializable onUpdate = PositionLevelLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)positionLevelLogDto, PositionLevelLogEventListener.class, (SerializableBiConsumer)onUpdate);
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<PositionLevelEntity> entities = this.positionLevelRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((CollectionUtils.isNotEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.positionLevelRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, PositionLevelEntity.class, PositionLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(eventListener -> eventListener.onDisable(voList));
        }
        for (PositionLevelEntity entity : entities) {
            PositionLevelDto oldDto = new PositionLevelDto();
            PositionLevelDto newDto = new PositionLevelDto();
            oldDto.setId(entity.getId());
            oldDto.setEnableStatus(entity.getEnableStatus());
            newDto.setId(entity.getId());
            newDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            PositionLevelLogDto positionLevelLogDto = new PositionLevelLogDto();
            positionLevelLogDto.setNewest(newDto);
            positionLevelLogDto.setOriginal(oldDto);
            SerializableBiConsumer & Serializable onUpdate = PositionLevelLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)positionLevelLogDto, PositionLevelLogEventListener.class, (SerializableBiConsumer)onUpdate);
        }
    }

    @Override
    public Page<PositionLevelEntity> findByConditions(Pageable pageable, PositionLevelDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (PositionLevelDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new PositionLevelDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.positionLevelRepository.findByConditions(pageable, dto);
    }

    @Override
    public List<PositionLevelEntity> findByIdsOrCodes(List<String> ids, List<String> positionLevelCodes) {
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(positionLevelCodes)) {
            return Lists.newArrayList();
        }
        return this.positionLevelRepository.findByIdsOrCodes(ids, positionLevelCodes, TenantUtils.getTenantCode());
    }

    @Override
    public void updateSuffixSequenceById(Integer suffixSequence, String id) {
        Validate.notBlank((CharSequence)id, (String)"\u804c\u4f4did\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(suffixSequence) && suffixSequence >= 0 ? 1 : 0) != 0, (String)"\u589e\u957f\u5e8f\u5217\u53f7\u4e0d\u7b26\u5408\u89c4\u8303", (Object[])new Object[0]);
        this.positionLevelRepository.updateSuffixSequenceById(suffixSequence, id);
    }

    @Override
    public List<PositionLevelEntity> findByRoleCodes(List<String> roleCodes, String tenantCode) {
        if (CollectionUtils.isEmpty(roleCodes) || StringUtils.isBlank((CharSequence)tenantCode)) {
            return Lists.newArrayList();
        }
        return this.positionLevelRepository.findByRoleCodes(roleCodes, tenantCode);
    }

    private void createValidation(PositionLevelDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getPositionLevelName(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEnableStatus(), (String)"\u7f3a\u5931\u542f\u7528\u72b6\u6001", (Object[])new Object[0]);
        Validate.isTrue((dto.getPositionLevelName().length() < 64 ? 1 : 0) != 0, (String)"\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getPositionLevelCode()) || dto.getPositionLevelCode().length() < 64 ? 1 : 0) != 0, (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<PositionLevelEntity> sameNameList = this.positionLevelRepository.findByName(dto.getPositionLevelName(), dto.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(sameNameList), (String)"\u5f53\u524d\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (Object[])new Object[0]);
    }

    private void updateValidation(PositionLevelDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPositionLevelCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPositionLevelName(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEnableStatus(), (String)"\u7f3a\u5931\u542f\u7528\u72b6\u6001", (Object[])new Object[0]);
        Validate.isTrue((dto.getPositionLevelName().length() < 64 ? 1 : 0) != 0, (String)"\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<PositionLevelEntity> sameNameList = this.positionLevelRepository.findByName(dto.getPositionLevelName(), dto.getTenantCode());
        if (CollectionUtils.isNotEmpty(sameNameList)) {
            sameNameList = sameNameList.stream().filter(x -> !dto.getId().equals(x.getId())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(sameNameList), (String)"\u5f53\u524d\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (Object[])new Object[0]);
        }
    }
}

