package com.biz.crm.mdm.business.position.local.authority;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @Author: heguanyun
 * @Date: 2022/4/7 17:25
 * description:
 */
@Component("positionSelectAuthorityModeRegister")
public class PositionAuthorityModeRegister implements SelectAuthorityModeRegister {
  @Override
  public String modeKey() {
    return "positionAuthorityModeRegister";
  }

  @Override
  public String modeName() {
    return "按照当前登录者/操作者所属职位进行职位维度的值确认";
  }

  @Override
  public String controlKey() {
    return "positionAuthorityModeRegister";
  }

  @Override
  public int sort() {
    return 16;
  }

  @Override
  public String groupCode() {
    return "position_group";
  }

  @Override
  public boolean isArrayValue() {
    return false;
  }

  @Override
  public boolean isStaticValue() {
    return false;
  }

  @Override
  public Class<?> modeValueClass() {
    return String.class;
  }

  @Override
  public Object staticValue(String[] staticValues) {
    return null;
  }

  @Override
  public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
    String identityType = loginDetails.getIdentityType();
    //如果不是后台管理用户，就不按职位字段进行权限控制
    if (!StringUtils.equals(identityType, "u")) {
      return null;
    }
    AbstractCrmUserIdentity loginUserDetails = (AbstractCrmUserIdentity) loginDetails;
    return loginUserDetails.getPostCode();
  }

  @Override
  public String converterKey() {
    return "chartEqualMarsAuthorityValueAstConverter";
  }
}
