package com.biz.crm.mdm.business.position.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/12/28 9:42
 * @description: 按照全部职位
 */
@Component("positionAuthorityModeRegisterForAll")
public class PositionAuthorityModeRegisterForAll implements SelectAuthorityModeRegister {

    @Override
    public String modeKey() {
        return "positionAuthorityModeRegisterForAll";
    }

    @Override
    public String modeName() {
        return "按照全部职位进行职位维度的值确认";
    }

    @Override
    public String controlKey() {
        return "positionAuthorityModeRegisterForAll";
    }

    @Override
    public int sort() {
        return 18;
    }

    @Override
    public String groupCode() {
        return "position_group";
    }

    @Override
    public boolean isArrayValue() {
        return false;
    }

    @Override
    public boolean isStaticValue() {
        return false;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] staticValues) {
        return null;
    }

    @Override
    public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
        String identityType = loginDetails.getIdentityType();
        //如果不是后台管理用户，就不按职位字段进行权限控制
        if (!StringUtils.equals(identityType, "u")) {
            return null;
        }
        //查所有，返回空
        return null;
    }

    @Override
    public String converterKey() {
        return "chartEqualMarsAuthorityValueAstConverter";
    }
}
