package com.biz.crm.mdm.business.position.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/12/28 9:42
 * @description: 按照固定职位
 */
@Component("positionAuthorityModeRegisterForSelect")
public class PositionAuthorityModeRegisterForSelect implements SelectAuthorityModeRegister {

    @Override
    public String modeKey() {
        return "positionAuthorityModeRegisterForSelect";
    }

    @Override
    public String modeName() {
        return "按照固定职位进行职位维度的值确认";
    }

    @Override
    public String controlKey() {
        return "positionAuthorityModeRegisterForSelect_select";
    }

    @Override
    public int sort() {
        return 19;
    }

    @Override
    public String groupCode() {
        return "position_group";
    }

    @Override
    public boolean isArrayValue() {
        return true;
    }

    @Override
    public boolean isStaticValue() {
        return true;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] staticValues) {
        return staticValues;
    }

    @Override
    public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
        return null;
    }

    @Override
    public String converterKey() {
        return "chartArrayMarsAuthorityAstConverter";
    }
}
