package com.biz.crm.mdm.business.position.local.authority;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2022/12/28 9:42
 * @description: 按照当前及下级职位
 */
@Component("positionDownAuthorityModeRegister")
public class PositionDownAuthorityModeRegister implements SelectAuthorityModeRegister {

    @Autowired(required = false)
    private ApplicationContext applicationContext;

    @Override
    public String modeKey() {
        return "positionDownAuthorityModeRegister";
    }

    @Override
    public String modeName() {
        return "按照当前登录者/操作者所属职位及其下级职位进行职位维度的值确认";
    }

    @Override
    public String controlKey() {
        return "positionDownAuthorityModeRegister";
    }

    @Override
    public int sort() {
        return 17;
    }

    @Override
    public String groupCode() {
        return "position_group";
    }

    @Override
    public boolean isArrayValue() {
        return false;
    }

    @Override
    public boolean isStaticValue() {
        return false;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] staticValues) {
        return null;
    }

    @Override
    public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
        String identityType = loginDetails.getIdentityType();
        //如果不是后台管理用户，就不按职位字段进行权限控制
        if (!StringUtils.equals(identityType, "u")) {
            return null;
        }

        PositionVoService positionVoService = applicationContext.getBean(PositionVoService.class);
        AbstractCrmUserIdentity loginUserDetails = (AbstractCrmUserIdentity) loginDetails;
        Object orgCodeObject = loginUserDetails.invokeFieldValue("postCode");
        if (orgCodeObject == null) {
            return false;
        }

        List<String> postCodes = Lists.newArrayList();
        List<PositionVo> children = positionVoService.findAllChildrenByCode(loginUserDetails.getPostCode());
        postCodes.addAll(children.stream().map(PositionVo::getPositionCode).distinct().collect(Collectors.toList()));
        return postCodes.toArray(new String[0]);
    }

    @Override
    public String converterKey() {
        return "chartEqualMarsAuthorityValueAstConverter";
    }
}
