package com.biz.crm.mdm.business.position.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * 职位实体类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PositionEntity", description = "职位实体")
@Entity
@TableName("mdm_position")
@Table(name = "mdm_position", indexes = {
    @Index(name = "mdm_position_index1", columnList = "tenant_code, position_code", unique = true),
    @Index(name = "mdm_position_index2", columnList = "parent_code"),
    @Index(name = "mdm_position_index3", columnList = "position_code"),
    @Index(name = "mdm_position_index4", columnList = "tenant_code,position_level_code"),
    @Index(name = "mdm_position_index5", columnList = "position_level_code"),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_position", comment = "职位表")
public class PositionEntity extends TenantFlagTreeOpEntity {

  private static final long serialVersionUID = -958070147101881346L;

  /**
   * 职位编码
   */
  @ApiModelProperty(name = "position_code", value = "职位编码", required = true)
  @Column(name = "position_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '职位编码'")
  private String positionCode;

  /**
   * MDG职位编码
   */
  @ApiModelProperty(name = "mdg_position_code", value = "MDG职位编码", required = true)
  @Column(name = "mdg_position_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT 'MDG职位编码'")
  private String mdgPositionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty(name = "position_name", value = "职位名称", required = true)
  @Column(name = "position_name", length = 255, columnDefinition = "VARCHAR(255) NOT NULL COMMENT '职位名称'")
  private String positionName;

  /**
   * 上级职位编码
   */
  @ApiModelProperty(name = "parent_code", value = "上级职位编码")
  @Column(name = "parent_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '上级职位编码'")
  private String parentCode;

  /**
   * 职位级别编码
   */
  @ApiModelProperty(name = "position_level_code", value = "职位级别编码", required = true)
  @Column(name = "position_level_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '职位级别编码'")
  private String positionLevelCode;

  /**
   * 职位来源[数据字典:mdm_position_source]
   */
  @ApiModelProperty(name = "position_source", value = "职位来源[数据字典:mdm_position_source]")
  @Column(name = "position_source", length = 64, columnDefinition = "VARCHAR(64) COMMENT '职位来源[数据字典:mdm_position_source] '")
  private String positionSource;

  /**
   * MDG职位名称生成TPM职位名称后缀增长序列号（同一个mdg职位编码有不同的数据，依次增加）
   */
  @ApiModelProperty(name = "suffix_sequence", value = "MDG职位名称生成TPM职位名称后缀增长序列号（同一个mdg编码只有一条有数据）")
  @Column(name = "suffix_sequence", length = 10, columnDefinition = "INT(10) NOT NULL COMMENT 'MDG职位名称生成TPM职位名称后缀增长序列号（同一个mdg编码只有一条有数据）'")
  private Integer suffixSequence;
}
