package com.biz.crm.mdm.business.position.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

import static org.apache.ibatis.type.JdbcType.VARCHAR;

/**
 * 职位-角色关联实体
 *
 * @author ning.zhang
 * @date 2021/10/13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PositionRoleEntity", description = "职位-角色关联表实体")
@Entity
@TableName("mdm_position_role")
@Table(name = "mdm_position_role", indexes = {
    @Index(name = "mdm_position_role_index1", columnList = "position_code"),
    @Index(name = "mdm_position_role_index2", columnList = "role_code"),
    @Index(name = "mdm_position_role_index3", columnList = "tenant_code,position_code,role_code",unique = true)
})
@org.hibernate.annotations.Table(appliesTo = "mdm_position_role", comment = "职位-角色关联表")
public class PositionRoleEntity extends TenantEntity {

  private static final long serialVersionUID = -212229065718443145L;

  /**
   * 职位编码
   */
  @ApiModelProperty(name = "position_code", value = "职位编码", required = true)
  @Column(name = "position_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '职位编码'")
  private String positionCode;

  /**
   * 角色编码
   */
  @ApiModelProperty(name = "role_code", value = "角色编码", required = true)
  @Column(name = "role_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '角色编码'")
  private String roleCode;

  /**
   * 角色名称
   */
  @ApiModelProperty(name = "role_name", value = "角色名称")
  @Column(name = "role_name", length = 64, columnDefinition = "VARCHAR(64)  COMMENT '角色名称'")
  private String roleName;

  /**
   * 有效期限
   */
  @ApiModelProperty(name = "indate_type", value = "有效期限")
  @Column(name = "indate_type", length = 64, columnDefinition = "VARCHAR(64)  COMMENT '有效期限'")
  private String indateType;

  /** 生效时间 */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("生效时间")
  @TableField(value = "start_time")
  @Column(name = "start_time", columnDefinition = "datetime COMMENT '生效时间'")
  private Date startTime;

  /** 失效时间 */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("失效时间")
  @TableField(value = "end_time")
  @Column(name = "end_time", columnDefinition = "datetime COMMENT '失效时间'")
  private Date endTime;

  /**
   * 备注
   */
  @TableField(value = "remark", jdbcType = VARCHAR)
  @Column(name = "remark", length = 400, columnDefinition = "varchar(400) COMMENT '备注'")
  private String remark;

}
