package com.biz.crm.mdm.business.position.local.service;

import com.biz.crm.mdm.business.position.local.entity.PositionEntity;
import com.biz.crm.mdm.business.position.sdk.dto.PositionDto;
import com.biz.crm.mdm.business.position.sdk.dto.RebindParentPositionDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;

import java.util.List;

/**
 * 职位表接口
 *
 * @author ning.zhang
 * @date 2021/10/12
 */
public interface PositionService {

  /**
   * 创建职位
   *
   * @param dto 请求参数dto
   * @return 职位实体
   */
  PositionEntity create(PositionDto dto);

  /**
   * 更新职位
   *
   * @param dto 请求参数dto
   * @return 职位实体
   */
  PositionEntity update(PositionDto dto);

  /**
   * 批量删除职位
   *
   * @param ids 职位id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用职位
   *
   * @param ids 职位id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用职位
   *
   * @param ids 职位id集合
   */
  void disableBatch(List<String> ids);

  /**
   * 通过职位级别编码集合获取职位列表
   *
   * @param positionLevelCodes 职位级别编码集合
   * @return 职位列表
   */
  List<PositionEntity> findByPositionLevelCodes(List<String> positionLevelCodes);

  /**
   * 根据职位id集合或者编码集合获取职位列表
   *
   * @param ids            职位ID集合
   * @param positionCodes 职位编码集合
   * @return 职位列表
   */
  List<PositionEntity> findByIdsOrCodes(List<String> ids, List<String> positionCodes);

  /**
   * 重置降维编码
   */
  void updateRuleCode();

  /**
   * 按ruleCode查询所有子节点(包含自身)
   *
   * @param ruleCode 降维编码
   * @return 所有子节点
   */
  List<PositionEntity> findAllChildrenByRuleCode(String ruleCode);

  /**
   * 通过角色编码集合获取职位信息
   * @param roleCodes 角色编码集合
   * @param tenantCode 租户编码
   * @return 职位实体集合
   */
  List<PositionEntity> findByRoleCodes(List<String> roleCodes ,String tenantCode);


  /**
   * 根据职位编码查询职位信息
   *
   * @param positionCode 职位编码
   * @return PositionEntity
   */
  PositionEntity findByPositionCode(String positionCode);

  /**
   * 重新绑定上级职位
   * @param dto 请求参数dto
   */
  void rebindParentPosition(RebindParentPositionDto dto);

  /**
   * 批量拉取职位数据
   *
   * @author huojia
   * @date 2022/12/30 14:54
   * @param dto
   **/
  void pullPositionList(MasterDataMdgBaseDto dto);

}
