/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/position/position"})
@Api(tags={"\u804c\u4f4d\u7ba1\u7406: PositionVo: \u804c\u4f4d\u4fe1\u606f"})
public class PositionVoController {
    private static final Logger log = LoggerFactory.getLogger(PositionVoController.class);
    @Autowired(required=false)
    private PositionVoService positionVoService;

    @ApiOperation(value="\u8be6\u60c5(\u7f16\u8f91\u9875\u9762\u4f7f\u7528),\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/findDetailsById"})
    public Result<PositionVo> findDetailsById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            List list = this.positionVoService.findDetailsByIdsOrCodes((List)Lists.newArrayList((Object[])new String[]{id}), null);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Result.ok((Object)null);
            }
            return Result.ok(list.get(0));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5(\u7f16\u8f91\u9875\u9762\u4f7f\u7528),\u901a\u8fc7\u804c\u4f4d\u7f16\u7801\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/findDetailsByPositionCode"})
    public Result<PositionVo> findDetailsByPositionCode(@RequestParam(value="positionCode") @ApiParam(name="positionCode", value="\u804c\u4f4d\u7f16\u7801") String positionCode) {
        try {
            List list = this.positionVoService.findDetailsByIdsOrCodes(null, (List)Lists.newArrayList((Object[])new String[]{positionCode}));
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Result.ok((Object)null);
            }
            return Result.ok(list.get(0));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u7f16\u7801\u5173\u8054\u7684\u804c\u4f4d\u53ca\u5176\u6240\u6709\u4e0a\u7ea7\u804c\u4f4d(\u5305\u542b\u89d2\u8272\u5173\u8054\u804c\u4f4d\u81ea\u8eab)")
    @GetMapping(value={"/findAllParentByRoleCodes"})
    public Result<List<PositionVo>> findAllParentByRoleCodes(@RequestParam(value="roleCodes") @ApiParam(name="roleCodes", value="\u89d2\u8272\u7f16\u7801\u96c6\u5408") List<String> roleCodes) {
        try {
            return Result.ok((Object)this.positionVoService.findAllParentByRoleCodes(roleCodes));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u8be5\u804c\u4f4d\u7684\u6240\u6709\u4e0b\u7ea7\u804c\u4f4d(\u5305\u542b\u81ea\u8eab)")
    @GetMapping(value={"/findAllChildrenByCode"})
    public Result<List<PositionVo>> findAllChildrenByCode(@RequestParam(value="positionCode") @ApiParam(name="positionCode", value="\u804c\u4f4d\u7f16\u7801") String positionCode) {
        try {
            return Result.ok((Object)this.positionVoService.findAllChildrenByCode(positionCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u8be5\u804c\u4f4d\u7684\u76f4\u5c5e\u4e0b\u7ea7")
    @GetMapping(value={"/findByParentCode"})
    public Result<List<PositionVo>> findByParentCode(@RequestParam(value="positionCode") @ApiParam(name="positionCode", value="\u804c\u4f4d\u7f16\u7801") String positionCode) {
        try {
            return Result.ok((Object)this.positionVoService.findByParentCode(positionCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4did\u6216\u8005code\u96c6\u5408\u67e5\u8be2\u804c\u4f4d\u5217\u8868")
    @GetMapping(value={"/findByIdsOrCodes"})
    public Result<List<PositionVo>> findByIdsOrCodes(@RequestParam(value="ids") @ApiParam(name="ids", value="\u804c\u4f4dID\u96c6\u5408") List<String> ids, @RequestParam(value="positionCodes") @ApiParam(name="positionCodes", value="\u804c\u4f4d\u7f16\u7801\u96c6\u5408") List<String> positionCodes) {
        try {
            return Result.ok((Object)this.positionVoService.findByIdsOrCodes(ids, positionCodes));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5927\u91cf\u804c\u4f4dcode\u67e5\u8be2\u804c\u4f4d\u5217\u8868")
    @PostMapping(value={"/findByLotPositionCodes"})
    public Result<List<PositionVo>> findByLotPositionCodes(@RequestBody List<String> positionCodes) {
        try {
            return Result.ok((Object)this.positionVoService.findByLotPositionCodes(positionCodes));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u7f16\u7801\u96c6\u5408")
    @GetMapping(value={"/findRolesByPositionCodes"})
    public Result<Set<String>> findRolesByPositionCodes(@RequestParam(value="positionCodes") @ApiParam(name="positionCodes", value="\u804c\u4f4d\u7f16\u7801\u96c6\u5408") List<String> positionCodes) {
        try {
            return Result.ok((Object)this.positionVoService.findRolesByPositionCodes(positionCodes));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

