/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.position.local.entity.PositionEntity;
import com.biz.crm.mdm.business.position.local.mapper.PositionMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PositionRepository
extends ServiceImpl<PositionMapper, PositionEntity> {
    @Autowired(required=false)
    private PositionMapper positionMapper;

    public List<PositionEntity> findByPositionLevelCodes(List<String> positionLevelCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(PositionEntity::getPositionLevelCode, positionLevelCodes)).list();
    }

    public PositionEntity findByPositionCode(String positionCode, String tenantCode) {
        return (PositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(PositionEntity::getPositionCode, (Object)positionCode)).one());
    }

    public List<PositionEntity> findByPositionNameLike(String positionName, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).like(PositionEntity::getPositionName, (Object)positionName)).select(new SFunction[]{PositionEntity::getPositionName}).list();
    }

    public List<PositionEntity> findByParentCode(String parentCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(PositionEntity::getParentCode, (Object)parentCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<PositionEntity> findByParentCodes(List<String> parentCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(PositionEntity::getParentCode, parentCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<PositionEntity> findByParentCodeIsNull(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(PositionEntity::getParentCode)).or()).eq(PositionEntity::getParentCode, (Object)"")).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void updateRuleCodeAndLevelNumByPositionCode(String positionCode, String ruleCode, Integer levelNum, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(PositionEntity::getPositionCode, (Object)positionCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).set(TenantFlagTreeOpEntity::getRuleCode, (Object)ruleCode)).set(TenantFlagTreeOpEntity::getLevelNum, (Object)levelNum)).update();
    }

    public List<PositionEntity> findByIdsOrCodes(List<String> ids, List<String> positionCodes, String tenantCode) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ids.removeIf(Objects::isNull);
        }
        if (CollectionUtils.isNotEmpty(positionCodes)) {
            positionCodes.removeIf(Objects::isNull);
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(CollectionUtils.isNotEmpty(positionCodes), PositionEntity::getPositionCode, positionCodes)).in(CollectionUtils.isNotEmpty(ids), UuidEntity::getId, ids)).list();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public List<PositionEntity> findByRuleCodesAndEnableStatus(List<String> ruleCodes, String enableStatus, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).in(TenantFlagTreeOpEntity::getRuleCode, ruleCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<PositionEntity> findCurAndChildrenByRuleCodes(List<String> ruleCodes, String enableStatus, String tenantCode) {
        return this.positionMapper.findCurAndChildrenByRuleCodes(ruleCodes, enableStatus, tenantCode);
    }

    public void updateOrphanParentCodeNull(String tenantCode) {
        this.positionMapper.updateOrphanParentCodeNull(tenantCode);
    }

    public List<PositionEntity> findAllChildrenByRuleCode(String ruleCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(TenantFlagTreeOpEntity::getRuleCode, (Object)ruleCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<PositionEntity> findByRoleCodes(List<String> roleCodes, String tenantCode) {
        return ((PositionMapper)this.baseMapper).findByRoleCodes(roleCodes, tenantCode);
    }

    public void updateByIdAndTenantCode(PositionEntity updateEntity, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{updateEntity.getId()});
        ((PositionMapper)this.baseMapper).update((Object)updateEntity, (Wrapper)lambdaUpdateWrapper);
    }

    public void updateBatchByIdAndTenantCode(List<PositionEntity> disableEntities, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        disableEntities.stream().forEach(positionEntity -> {
            lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
            lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{positionEntity.getId()});
            ((PositionMapper)this.baseMapper).update(positionEntity, (Wrapper)lambdaUpdateWrapper);
        });
    }

    public PositionEntity findByIdAndTenantCode(String id, String tenantCode) {
        return (PositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public List<PositionEntity> findByPositionCodes(List<String> positionCodeList) {
        if (CollectionUtils.isEmpty(positionCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(PositionEntity::getPositionCode, positionCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<PositionEntity> listParentUser() {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<PositionEntity> findByMdgPositionCodes(List<String> mdgPositionCodeList) {
        if (CollectionUtils.isEmpty(mdgPositionCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(PositionEntity::getMdgPositionCode, mdgPositionCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }
}

