/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.position.local.entity.PositionRoleEntity;
import com.biz.crm.mdm.business.position.local.repository.PositionRoleRepository;
import com.biz.crm.mdm.business.position.local.service.PositionRoleService;
import com.biz.crm.mdm.business.position.sdk.dto.BindPositionRoleDto;
import com.biz.crm.mdm.business.position.sdk.dto.PositionDto;
import com.biz.crm.mdm.business.position.sdk.dto.PositionRoleDto;
import com.biz.crm.mdm.business.position.sdk.enums.IndateTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PositionRoleServiceImpl
implements PositionRoleService {
    @Autowired(required=false)
    private PositionRoleRepository positionRoleRepository;
    @Autowired(required=false)
    private RoleVoCacheService roleVoCacheService;

    @Override
    public List<PositionRoleEntity> findByPositionCode(String positionCode) {
        if (StringUtils.isEmpty((CharSequence)positionCode)) {
            return Lists.newArrayList();
        }
        return this.positionRoleRepository.findByPositionCode(positionCode, TenantUtils.getTenantCode());
    }

    @Override
    public List<PositionRoleEntity> findByPositionCodes(List<String> positionCodes) {
        if (CollectionUtils.isEmpty(positionCodes)) {
            return Lists.newArrayList();
        }
        return this.positionRoleRepository.findByPositionCodes(positionCodes, TenantUtils.getTenantCode());
    }

    @Override
    public void unbindByPositionCodes(List<String> positionCodes) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(positionCodes), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List<PositionRoleEntity> entities = this.positionRoleRepository.findByPositionCodes(positionCodes, tenantCode);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.positionRoleRepository.deleteByPositionCodes(positionCodes, tenantCode);
        entities.forEach(entity -> this.roleVoCacheService.clearCache(tenantCode, entity.getRoleCode()));
    }

    @Override
    public void bindByPositionCodeAndRoleCodes(String positionCode, PositionDto dto) {
        Validate.notBlank((CharSequence)positionCode, (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto, (String)"\u804c\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)dto.getRoleCodeList()) && CollectionUtils.isEmpty((Collection)dto.getPositionRoles())) {
            return;
        }
        ArrayList roleEntities = Lists.newArrayList();
        String tenantCode = TenantUtils.getTenantCode();
        if (!CollectionUtils.isEmpty((Collection)dto.getRoleCodeList())) {
            roleEntities.addAll(dto.getRoleCodeList().stream().map(roleCode -> {
                PositionRoleEntity entity = new PositionRoleEntity();
                entity.setRoleCode((String)roleCode);
                entity.setPositionCode(positionCode);
                entity.setTenantCode(tenantCode);
                return entity;
            }).collect(Collectors.toList()));
        } else {
            this.validationData(dto.getPositionRoles());
            roleEntities.addAll(dto.getPositionRoles().stream().map(roleDto -> {
                PositionRoleEntity entity = new PositionRoleEntity();
                entity.setEndTime(roleDto.getEndTime());
                entity.setStartTime(roleDto.getStartTime());
                entity.setIndateType(roleDto.getIndateType());
                entity.setRoleName(roleDto.getRoleName());
                entity.setPositionCode(positionCode);
                entity.setRoleCode(roleDto.getRoleCode());
                entity.setTenantCode(tenantCode);
                entity.setRemark(roleDto.getRemark());
                return entity;
            }).collect(Collectors.toList()));
        }
        this.positionRoleRepository.saveBatch(roleEntities);
        roleEntities.forEach(roleEntity -> this.roleVoCacheService.clearCache(tenantCode, roleEntity.getRoleCode()));
    }

    @Override
    public List<PositionRoleEntity> findByRoleCodes(List<String> roleCodes) {
        if (CollectionUtils.isEmpty(roleCodes)) {
            return Lists.newArrayList();
        }
        return this.positionRoleRepository.findByRoleCodes(roleCodes, TenantUtils.getTenantCode());
    }

    @Override
    public void bindByPositionCodesAndRoleCode(BindPositionRoleDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ed1\u5b9a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getRoleCode(), (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getPositionRoles()) || !CollectionUtils.isEmpty((Collection)dto.getPositionCodeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801", (Object[])new Object[0]);
        String roleCode = dto.getRoleCode();
        String tenantCode = TenantUtils.getTenantCode();
        ArrayList entities = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)dto.getPositionCodeList())) {
            List positionCodes = dto.getPositionCodeList();
            List<PositionRoleEntity> list = this.positionRoleRepository.findByPositionCodesAndRoleCode(positionCodes, roleCode, tenantCode);
            if (CollectionUtils.isNotEmpty(list)) {
                List existPositionCodes = list.stream().map(PositionRoleEntity::getPositionCode).collect(Collectors.toList());
                positionCodes = positionCodes.stream().filter(s -> !existPositionCodes.contains(s)).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty((Collection)positionCodes)) {
                return;
            }
            entities.addAll(positionCodes.stream().map(positionCode -> {
                PositionRoleEntity entity = new PositionRoleEntity();
                entity.setTenantCode(tenantCode);
                entity.setRoleCode(roleCode);
                entity.setPositionCode((String)positionCode);
                return entity;
            }).collect(Collectors.toList()));
        } else {
            List positionRoles = dto.getPositionRoles();
            this.validationData(positionRoles);
            List<String> positionCodes = positionRoles.stream().map(PositionRoleDto::getPositionCode).collect(Collectors.toList());
            List<PositionRoleEntity> list = this.positionRoleRepository.findByPositionCodesAndRoleCode(positionCodes, roleCode, tenantCode);
            if (CollectionUtils.isNotEmpty(list)) {
                List existPositionCodes = list.stream().map(PositionRoleEntity::getPositionCode).collect(Collectors.toList());
                positionCodes = positionCodes.stream().filter(s -> !existPositionCodes.contains(s)).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(positionCodes)) {
                return;
            }
            for (PositionRoleDto roleDto : positionRoles) {
                if (!positionCodes.contains(roleDto.getPositionCode())) continue;
                PositionRoleEntity entity = new PositionRoleEntity();
                entity.setEndTime(roleDto.getEndTime());
                entity.setStartTime(roleDto.getStartTime());
                entity.setIndateType(roleDto.getIndateType());
                entity.setRoleName(roleDto.getRoleName());
                entity.setPositionCode(roleDto.getPositionCode());
                entity.setTenantCode(tenantCode);
                entity.setRoleCode(roleCode);
                entity.setRemark(roleDto.getRemark());
                entities.add(entity);
            }
        }
        this.positionRoleRepository.saveBatch(entities);
    }

    @Override
    public void unbindByPositionCodesAndRoleCode(List<String> positionCodes, String roleCode) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(positionCodes), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)roleCode, (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801", (Object[])new Object[0]);
        List<PositionRoleEntity> list = this.positionRoleRepository.findByPositionCodesAndRoleCode(positionCodes, roleCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<String> positionRoleIds = list.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.positionRoleRepository.removeByIdsAndTenantCode(positionRoleIds, TenantUtils.getTenantCode());
    }

    private void validationData(List<PositionRoleDto> positionRoles) {
        Validate.notNull(positionRoles, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        for (PositionRoleDto dto : positionRoles) {
            Validate.notBlank((CharSequence)dto.getIndateType(), (String)"\u6709\u6548\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (!IndateTypeEnum.CUSTOMIZE_TIME.getDictCode().equals(dto.getIndateType())) continue;
            Validate.notNull((Object)dto.getStartTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)dto.getStartTime().before(dto.getEndTime()), (String)"\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        }
    }
}

