/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.position.level.sdk.service.PositionLevelVoService;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import com.biz.crm.mdm.business.position.local.entity.PositionEntity;
import com.biz.crm.mdm.business.position.local.repository.PositionRepository;
import com.biz.crm.mdm.business.position.local.service.PositionRoleService;
import com.biz.crm.mdm.business.position.local.service.PositionService;
import com.biz.crm.mdm.business.position.sdk.dto.PositionDto;
import com.biz.crm.mdm.business.position.sdk.dto.PositionLogDto;
import com.biz.crm.mdm.business.position.sdk.dto.RebindParentPositionDto;
import com.biz.crm.mdm.business.position.sdk.dto.RelationDataDto;
import com.biz.crm.mdm.business.position.sdk.enums.PositionSourceEnum;
import com.biz.crm.mdm.business.position.sdk.event.PositionEventListener;
import com.biz.crm.mdm.business.position.sdk.event.PositionLogEventListener;
import com.biz.crm.mdm.business.position.sdk.vo.PositionEventVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationEventVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.enums.EffStatusEnum;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgPositionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PositionServiceImpl
implements PositionService {
    private static final Logger log = LoggerFactory.getLogger(PositionServiceImpl.class);
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private PositionLevelVoService positionLevelVoService;
    @Autowired(required=false)
    private PositionRepository positionRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Autowired(required=false)
    private PositionRoleService positionRoleService;
    @Autowired(required=false)
    @Lazy
    private List<PositionEventListener> listeners;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private MasterDataMdgService masterDataMdgService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private TreeRuleCodeStrategy treeRuleCodeStrategy;

    @Override
    @Transactional
    public PositionEntity create(PositionDto dto) {
        this.createValidation(dto);
        PositionEntity entity = (PositionEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, PositionEntity.class, HashSet.class, ArrayList.class, new String[0]));
        if (StringUtils.isEmpty((CharSequence)entity.getPositionName())) {
            List positionLevels = this.positionLevelVoService.findByIdsOrCodes(null, (List)Lists.newArrayList((Object[])new String[]{dto.getPositionLevelCode()}));
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)positionLevels) ? 1 : 0) != 0, (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7ea7\u522b", (Object[])new Object[0]);
            PositionLevelVo positionLevel = (PositionLevelVo)positionLevels.get(0);
            List<PositionEntity> entities = this.positionRepository.findByPositionNameLike(positionLevel.getPositionLevelName(), dto.getTenantCode());
            Set positionNameSet = !CollectionUtils.isEmpty(entities) ? entities.stream().map(PositionEntity::getPositionName).collect(Collectors.toSet()) : null;
            entity.setPositionName(this.positionLevelVoService.createPositionNameByPositionLevelCode(dto.getPositionLevelCode(), positionNameSet, dto.getTenantCode()));
        }
        if (StringUtils.isEmpty((CharSequence)entity.getPositionCode())) {
            entity.setPositionCode((String)this.generateCodeService.generateCode("ZW", 1).get(0));
        }
        PositionEntity position = this.positionRepository.findByPositionCode(entity.getPositionCode(), dto.getTenantCode());
        Validate.isTrue((boolean)Objects.isNull((Object)position), (String)"\u804c\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        int levelNum = 1;
        PositionEntity parentPosition = null;
        if (StringUtils.isNotEmpty((CharSequence)dto.getParentCode())) {
            parentPosition = this.positionRepository.findByPositionCode(dto.getParentCode(), dto.getTenantCode());
            Validate.notNull((Object)((Object)parentPosition), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(parentPosition.getEnableStatus()), (String)"\u4e0a\u7ea7\u804c\u4f4d\u88ab\u7981\u7528", (Object[])new Object[0]);
            levelNum = parentPosition.getLevelNum() + 1;
        }
        entity.setRuleCode(this.createRuleCodeByParentPosition(parentPosition));
        entity.setLevelNum(levelNum);
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setSuffixSequence(1);
        this.positionRepository.save((Object)entity);
        this.positionRoleService.bindByPositionCodeAndRoleCodes(entity.getPositionCode(), dto);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            PositionEventVo vo = (PositionEventVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, PositionEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setPositionCode(entity.getPositionCode());
            this.listeners.forEach(positionEventListener -> positionEventListener.onCreate(vo));
        }
        PositionLogDto positionLogDto = new PositionLogDto();
        positionLogDto.setNewest((PositionDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PositionDto.class, HashSet.class, ArrayList.class, new String[0]));
        SerializableBiConsumer & Serializable onCreate = PositionLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)positionLogDto, PositionLogEventListener.class, (SerializableBiConsumer)onCreate);
        return entity;
    }

    @Override
    @Transactional
    public PositionEntity update(PositionDto dto) {
        this.updateValidation(dto);
        PositionEntity entity = this.positionRepository.findByIdAndTenantCode(dto.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)entity), (String)"\u804c\u4f4d\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)entity.getPositionCode().equals(dto.getPositionCode()), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        String entityRuleCode = entity.getRuleCode();
        boolean parentChange = (StringUtils.isNotBlank((CharSequence)dto.getParentCode()) || StringUtils.isNotBlank((CharSequence)entity.getParentCode())) && !Objects.equals(dto.getParentCode(), entity.getParentCode());
        int levelNum = 1;
        PositionEntity parentPosition = null;
        if (StringUtils.isNotBlank((CharSequence)dto.getParentCode()) && parentChange) {
            Validate.isTrue((!dto.getParentCode().equals(entity.getPositionCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u4e3a\u5f53\u524d\u804c\u4f4d", (Object[])new Object[0]);
            parentPosition = this.positionRepository.findByPositionCode(dto.getParentCode(), dto.getTenantCode());
            Validate.notNull((Object)((Object)parentPosition), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(parentPosition.getEnableStatus()), (String)"\u4e0a\u7ea7\u804c\u4f4d\u88ab\u7981\u7528", (Object[])new Object[0]);
            String parentRuleCode = parentPosition.getRuleCode();
            Validate.notBlank((CharSequence)parentRuleCode, (String)"\u4e0a\u7ea7\u804c\u4f4druleCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((!parentRuleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u662f\u5f53\u524d\u804c\u4f4d\u7684\u4e0b\u7ea7\u804c\u4f4d", (Object[])new Object[0]);
            levelNum = parentPosition.getLevelNum() + 1;
        }
        PositionEntity updateEntity = (PositionEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, PositionEntity.class, HashSet.class, ArrayList.class, new String[0]));
        updateEntity.setParentCode(Optional.ofNullable(dto.getParentCode()).orElse(""));
        updateEntity.setSuffixSequence(entity.getSuffixSequence());
        this.positionRepository.updateByIdAndTenantCode(updateEntity, TenantUtils.getTenantCode());
        if (parentChange) {
            String ruleCode = this.createRuleCodeByParentPosition(parentPosition);
            this.updateRuleCodeAllChildren(entity.getPositionCode(), ruleCode, levelNum);
        }
        this.positionRoleService.unbindByPositionCodes(Lists.newArrayList((Object[])new String[]{dto.getPositionCode()}));
        if (!CollectionUtils.isEmpty((Collection)dto.getRoleCodeList()) || !CollectionUtils.isEmpty((Collection)dto.getPositionRoles())) {
            this.positionRoleService.bindByPositionCodeAndRoleCodes(dto.getPositionCode(), dto);
        }
        if (!CollectionUtils.isEmpty(this.listeners)) {
            PositionEventVo oldVo = (PositionEventVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, PositionEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            PositionEventVo newVo = (PositionEventVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, PositionEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(positionEventListener -> positionEventListener.onUpdate(oldVo, newVo));
        }
        PositionLogDto positionLogDto = new PositionLogDto();
        positionLogDto.setOriginal((PositionDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PositionDto.class, HashSet.class, ArrayList.class, new String[0]));
        positionLogDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = PositionLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)positionLogDto, PositionLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.positionRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Map<String, PositionEntity> entityMap = entities.stream().collect(Collectors.toMap(PositionEntity::getPositionCode, t -> t));
        List<PositionEntity> childrenPositions = this.positionRepository.findByParentCodes(Lists.newArrayList(entityMap.keySet()), tenantCode);
        if (!CollectionUtils.isEmpty(childrenPositions)) {
            throw new IllegalArgumentException("\u804c\u4f4d[" + entityMap.get(childrenPositions.get(0).getParentCode()).getPositionName() + "]\u5b58\u5728\u4e0b\u7ea7\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.positionRepository.updateDelFlagByIds(ids);
        this.positionRoleService.unbindByPositionCodes(Lists.newArrayList(entityMap.keySet()));
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, PositionEntity.class, PositionEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(positionEventListener -> positionEventListener.onDelete(voList));
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        List<PositionEntity> parentDisableList;
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.positionRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        List ruleCodes = entities.stream().map(TenantFlagTreeOpEntity::getRuleCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Validate.notNull((Object)treeRuleCodeStrategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565", (Object[])new Object[0]);
        Set parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodeByRuleCodesExcludeAnySelf(6, ruleCodes);
        if (!CollectionUtils.isEmpty((Collection)parentRuleCodes) && !CollectionUtils.isEmpty(parentDisableList = this.positionRepository.findByRuleCodesAndEnableStatus(Lists.newArrayList((Iterable)parentRuleCodes), EnableStatusEnum.DISABLE.getCode(), TenantUtils.getTenantCode()))) {
            throw new IllegalArgumentException("\u5b58\u5728\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u804c\u4f4d[" + parentDisableList.get(0).getPositionName() + "],\u4e0d\u80fd\u542f\u7528\u5f53\u524d\u804c\u4f4d");
        }
        this.positionRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, PositionEntity.class, PositionEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(positionEventListener -> positionEventListener.onEnable(voList));
        }
        List<PositionEntity> byIdsOrCodes = this.positionRepository.findByIdsOrCodes(ids, null, TenantUtils.getTenantCode());
        for (PositionEntity byIdsOrCode : byIdsOrCodes) {
            PositionLogDto positionLogDto = new PositionLogDto();
            PositionDto oldDto = new PositionDto();
            PositionDto newDto = new PositionDto();
            oldDto.setId(byIdsOrCode.getId());
            oldDto.setEnableStatus(byIdsOrCode.getEnableStatus());
            newDto.setId(byIdsOrCode.getId());
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            positionLogDto.setOriginal(oldDto);
            positionLogDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onUpdate = PositionLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)positionLogDto, PositionLogEventListener.class, (SerializableBiConsumer)onUpdate);
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.positionRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        List<String> ruleCodes = entities.stream().map(TenantFlagTreeOpEntity::getRuleCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<PositionEntity> disableEntities = this.positionRepository.findCurAndChildrenByRuleCodes(ruleCodes, EnableStatusEnum.ENABLE.getCode(), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(disableEntities)) {
            return;
        }
        disableEntities.forEach(positionEntity -> positionEntity.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.positionRepository.updateBatchByIdAndTenantCode(disableEntities, TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(disableEntities, PositionEntity.class, PositionEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(positionEventListener -> positionEventListener.onDisable(voList));
        }
        List<PositionEntity> byIdsOrCodes = this.positionRepository.findByIdsOrCodes(ids, null, TenantUtils.getTenantCode());
        for (PositionEntity byIdsOrCode : byIdsOrCodes) {
            PositionLogDto positionLogDto = new PositionLogDto();
            PositionDto oldDto = new PositionDto();
            PositionDto newDto = new PositionDto();
            oldDto.setId(byIdsOrCode.getId());
            oldDto.setEnableStatus(byIdsOrCode.getEnableStatus());
            newDto.setId(byIdsOrCode.getId());
            newDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            positionLogDto.setOriginal(oldDto);
            positionLogDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onUpdate = PositionLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)positionLogDto, PositionLogEventListener.class, (SerializableBiConsumer)onUpdate);
        }
    }

    @Override
    public List<PositionEntity> findByPositionLevelCodes(List<String> positionLevelCodes) {
        if (CollectionUtils.isEmpty(positionLevelCodes)) {
            return Lists.newArrayList();
        }
        return this.positionRepository.findByPositionLevelCodes(positionLevelCodes, TenantUtils.getTenantCode());
    }

    @Override
    public List<PositionEntity> findByIdsOrCodes(List<String> ids, List<String> positionCodes) {
        if (CollectionUtils.isEmpty(positionCodes) && CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return this.positionRepository.findByIdsOrCodes(ids, positionCodes, TenantUtils.getTenantCode());
    }

    @Override
    public void updateRuleCode() {
        String tenantCode = TenantUtils.getTenantCode();
        this.positionRepository.updateOrphanParentCodeNull(tenantCode);
        List<PositionEntity> list = this.positionRepository.findByParentCodeIsNull(tenantCode);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
            TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
            Validate.notNull((Object)treeRuleCodeStrategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565", (Object[])new Object[0]);
            this.updateRuleCodeAllChildren(list.get(i).getPositionCode(), treeRuleCodeStrategy.generateByNum(6, i + 1), 1);
        }
    }

    @Override
    public List<PositionEntity> findAllChildrenByRuleCode(String ruleCode) {
        if (StringUtils.isBlank((CharSequence)ruleCode)) {
            return Lists.newArrayList();
        }
        return this.positionRepository.findAllChildrenByRuleCode(ruleCode, TenantUtils.getTenantCode());
    }

    @Override
    public List<PositionEntity> findByRoleCodes(List<String> roleCodes, String tenantCode) {
        if (CollectionUtils.isEmpty(roleCodes) || StringUtils.isBlank((CharSequence)tenantCode)) {
            return Lists.newArrayList();
        }
        return this.positionRepository.findByRoleCodes(roleCodes, tenantCode);
    }

    @Override
    public PositionEntity findByPositionCode(String positionCode) {
        return this.positionRepository.findByPositionCode(positionCode, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void rebindParentPosition(RebindParentPositionDto dto) {
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getUnderlingPositionCodeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4e0b\u7ea7\u804c\u4f4d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPositionCode(), (String)"\u7f3a\u5931\u4e0a\u7ea7\u804c\u4f4d", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List<PositionEntity> positionEntities = this.positionRepository.findByIdsOrCodes(null, dto.getUnderlingPositionCodeList(), tenantCode);
        Validate.isTrue((!CollectionUtils.isEmpty(positionEntities) && positionEntities.size() == dto.getUnderlingPositionCodeList().size() ? 1 : 0) != 0, (String)"\u6570\u636e\u91cd\u7ed1\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        PositionEntity parentPosition = this.positionRepository.findByPositionCode(dto.getPositionCode(), tenantCode);
        Validate.notNull((Object)((Object)parentPosition), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((!dto.getUnderlingPositionCodeList().contains(parentPosition.getPositionCode()) ? 1 : 0) != 0, (String)String.format("\u6240\u9009\u804c\u4f4d[%s]\u4e0d\u80fd\u662f\u81ea\u8eab\u4e0a\u7ea7\u804c\u4f4d", parentPosition.getPositionName()), (Object[])new Object[0]);
        TreeRuleCodeStrategy strategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Set ruleCodes = strategy.findParentRuleCodeByRuleCode(6, parentPosition.getRuleCode());
        List<PositionEntity> allParentPositions = this.positionRepository.findByRuleCodesAndEnableStatus(Lists.newArrayList((Iterable)ruleCodes), null, tenantCode);
        allParentPositions.forEach(positionEntity -> Validate.isTrue((!dto.getUnderlingPositionCodeList().contains(positionEntity.getPositionCode()) ? 1 : 0) != 0, (String)String.format("\u6240\u9009\u804c\u4f4d[%s]\u662f[%s]\u7684\u4e0b\u7ea7\u804c\u4f4d\uff0c\u4e0d\u80fd\u9009\u62e9\u4f5c\u4e3a\u4e0a\u7ea7", parentPosition.getPositionName(), positionEntity.getPositionName()), (Object[])new Object[0]));
        Integer levelNum = parentPosition.getLevelNum() + 1;
        positionEntities.forEach(positionEntity -> {
            String ruleCode = this.createRuleCodeByParentPosition(parentPosition);
            positionEntity.setRuleCode(ruleCode);
            positionEntity.setLevelNum(levelNum);
            positionEntity.setParentCode(parentPosition.getPositionCode());
            this.positionRepository.updateByIdAndTenantCode((PositionEntity)((Object)positionEntity), TenantUtils.getTenantCode());
            this.updateRuleCodeAllChildren(positionEntity.getPositionCode(), ruleCode, levelNum);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullPositionList(MasterDataMdgBaseDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new MasterDataMdgBaseDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageNum())) {
            dto.setPageNum("1");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize("400");
        }
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        if (!StringUtils.isEmpty((CharSequence)dto.getUdate())) {
            lockKey = dto.getUdate();
        }
        boolean lock = true;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            List masterDataMdgPositionVos = this.masterDataMdgService.pullPositionList(dto);
            if (CollectionUtils.isEmpty((Collection)masterDataMdgPositionVos)) {
                return;
            }
            List<PositionEventVo> pullList = this.positionValidate(masterDataMdgPositionVos);
            List<String> mdgPositionCodeList = pullList.stream().map(PositionEventVo::getMdgPositionCode).collect(Collectors.toList());
            List<PositionEntity> byMdgPositionCodes = this.positionRepository.findByMdgPositionCodes(mdgPositionCodeList);
            String tenantCode = TenantUtils.getTenantCode();
            if (CollectionUtils.isEmpty(byMdgPositionCodes)) {
                List positionCodeList = this.generateCodeService.generateCode("ZW", pullList.size());
                Iterator iterator = positionCodeList.iterator();
                pullList.forEach(pull -> pull.setPositionCode((String)iterator.next()));
                List positionEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(pullList, PositionEventVo.class, PositionEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                positionEntities.forEach(positionEntity -> {
                    if (!StringUtils.isEmpty((CharSequence)positionEntity.getPositionName())) {
                        positionEntity.setPositionName(positionEntity.getPositionName() + "_" + 1);
                    }
                    positionEntity.setSuffixSequence(1);
                    positionEntity.setRuleCode(this.treeRuleCodeStrategy.generateByNum(6, positionEntities.size()));
                    positionEntity.setLevelNum(1);
                    positionEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    positionEntity.setTenantCode(tenantCode);
                });
                this.saveOrUpdateMdgBatch(positionEntities, null, pullList);
                return;
            }
            Map<String, PositionEntity> initMap = byMdgPositionCodes.stream().filter(positionEntity -> positionEntity.getSuffixSequence() == 1).collect(Collectors.toMap(PositionEntity::getMdgPositionCode, Function.identity()));
            Map<String, List<PositionEntity>> allMap = byMdgPositionCodes.stream().collect(Collectors.groupingBy(PositionEntity::getMdgPositionCode));
            Map<String, PositionEventVo> eventVoMap = pullList.stream().collect(Collectors.toMap(PositionEventVo::getMdgPositionCode, Function.identity()));
            List positionEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(pullList, PositionEventVo.class, PositionEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            ArrayList<PositionEventVo> saveEventList = new ArrayList<PositionEventVo>();
            ArrayList<PositionEntity> saveList = new ArrayList<PositionEntity>();
            ArrayList<PositionEntity> updateList = new ArrayList<PositionEntity>();
            this.buildEntity(positionEntities, initMap, allMap, eventVoMap, saveList, updateList, saveEventList);
            if (!CollectionUtils.isEmpty(saveList)) {
                List positionCodeList = this.generateCodeService.generateCode("ZW", pullList.size());
                Iterator iterator = positionCodeList.iterator();
                saveList.forEach(save -> save.setPositionCode((String)iterator.next()));
            }
            this.saveOrUpdateMdgBatch(saveList, updateList, saveEventList);
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    private void buildEntity(List<PositionEntity> positionEntities, Map<String, PositionEntity> initMap, Map<String, List<PositionEntity>> allMap, Map<String, PositionEventVo> eventVoMap, List<PositionEntity> saveList, List<PositionEntity> updateList, List<PositionEventVo> saveEventList) {
        String tenantCode = TenantUtils.getTenantCode();
        positionEntities.forEach(pull -> {
            if (initMap.containsKey(pull.getMdgPositionCode())) {
                PositionEntity positionEntity = (PositionEntity)((Object)((Object)initMap.get(pull.getMdgPositionCode())));
                List updateNameList = (List)allMap.get(pull.getMdgPositionCode());
                updateNameList.forEach(updateName -> {
                    if (StringUtils.isEmpty((CharSequence)updateName.getPositionName())) {
                        updateName.setPositionName(pull.getPositionName());
                    } else {
                        updateName.setPositionName(updateName.getPositionName().replace(positionEntity.getPositionName(), pull.getPositionName()));
                    }
                });
                updateList.addAll(updateNameList);
                List positionEventVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)updateNameList, PositionEntity.class, PositionEventVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                positionEventVos.forEach(positionEventVo -> positionEventVo.setRelationData(((PositionEventVo)eventVoMap.get(positionEventVo.getMdgPositionCode())).getRelationData()));
                saveEventList.addAll(positionEventVos);
            } else {
                if (!StringUtils.isEmpty((CharSequence)pull.getPositionName())) {
                    pull.setPositionName(pull.getPositionName() + "_" + 1);
                }
                pull.setSuffixSequence(1);
                pull.setRuleCode(this.treeRuleCodeStrategy.generateByNum(6, positionEntities.size()));
                pull.setLevelNum(1);
                pull.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                pull.setTenantCode(tenantCode);
                saveList.add((PositionEntity)((Object)pull));
                saveEventList.add((PositionEventVo)eventVoMap.get(pull.getMdgPositionCode()));
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    void saveOrUpdateMdgBatch(List<PositionEntity> saveList, List<PositionEntity> updateList, List<PositionEventVo> saveEventList) {
        if (!CollectionUtils.isEmpty(saveList)) {
            this.positionRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.positionRepository.updateBatchById(updateList);
        }
        for (PositionEventListener positionEventListener : this.listeners) {
            positionEventListener.onCreate(saveEventList);
        }
    }

    private void unLock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u5c97\u4f4d\u7ea7\u522b\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisMutexService.unlock("position_lock:lock:" + lockKey);
    }

    private boolean lock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u5c97\u4f4d\u52a0\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisMutexService.tryLock("position_lock:lock:" + lockKey, TimeUnit.HOURS, 12);
    }

    private List<PositionEventVo> positionValidate(List<MasterDataMdgPositionVo> masterDataMdgPositionVos) {
        HashMap codeMap = new HashMap(8);
        ArrayList<PositionEventVo> pullList = new ArrayList<PositionEventVo>();
        masterDataMdgPositionVos.forEach(masterDataMdgPositionVo -> {
            if (StringUtils.isEmpty((CharSequence)masterDataMdgPositionVo.getPOSITIONNBR())) {
                throw new RuntimeException("\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a\uff1a" + JSON.toJSONString((Object)masterDataMdgPositionVo));
            }
            List positionVos = Optional.ofNullable(codeMap.get(masterDataMdgPositionVo.getPOSITIONNBR())).orElse(new ArrayList());
            positionVos.add(masterDataMdgPositionVo);
            codeMap.put(masterDataMdgPositionVo.getPOSITIONNBR(), positionVos);
            if (positionVos.size() > 1) {
                log.info("\u6570\u636e\uff1a" + JSON.toJSONString((Object)positionVos) + "\u91cd\u590d\u62c9\u53d6\uff0c\u8bf7\u68c0\u67e5\uff01");
                return;
            }
            PositionEventVo positionEventVo = new PositionEventVo();
            positionEventVo.setMdgPositionCode(masterDataMdgPositionVo.getPOSITIONNBR());
            positionEventVo.setPositionName(masterDataMdgPositionVo.getDESCR());
            positionEventVo.setPositionSource(PositionSourceEnum.MDG.getCode());
            if (EffStatusEnum.ENABLE.getCode().equals(masterDataMdgPositionVo.getEFFSTATUS())) {
                positionEventVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            } else {
                positionEventVo.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            }
            ArrayList<PositionRelationEventVo> positionRelationEventVos = new ArrayList<PositionRelationEventVo>();
            PositionRelationEventVo positionRelationEventVo = new PositionRelationEventVo();
            positionRelationEventVo.setRelationKey("org");
            ArrayList<RelationDataDto> relationDataDtoList = new ArrayList<RelationDataDto>();
            RelationDataDto relationDataDto = new RelationDataDto();
            relationDataDto.setCode(masterDataMdgPositionVo.getDEPTID());
            relationDataDtoList.add(relationDataDto);
            positionRelationEventVo.setRelationData(relationDataDtoList);
            positionRelationEventVos.add(positionRelationEventVo);
            positionEventVo.setRelationData(positionRelationEventVos);
            pullList.add(positionEventVo);
        });
        return pullList;
    }

    private void updateRuleCodeAllChildren(String positionCode, String ruleCode, Integer levelNum) {
        this.positionRepository.updateRuleCodeAndLevelNumByPositionCode(positionCode, ruleCode, levelNum, TenantUtils.getTenantCode());
        List<PositionEntity> list = this.positionRepository.findByParentCode(positionCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            PositionEntity childrenPosition = list.get(i);
            Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
            TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
            Validate.notNull((Object)treeRuleCodeStrategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565", (Object[])new Object[0]);
            this.updateRuleCodeAllChildren(childrenPosition.getPositionCode(), ruleCode + treeRuleCodeStrategy.generateByNum(6, i + 1), levelNum + 1);
        }
    }

    private String createRuleCodeByParentPosition(PositionEntity parentPosition) {
        List<PositionEntity> children;
        String tenantCode = TenantUtils.getTenantCode();
        String parentRuleCode = null;
        ArrayList childrenDto = Lists.newArrayList();
        if (parentPosition != null) {
            children = this.positionRepository.findByParentCode(parentPosition.getPositionCode(), tenantCode);
            parentRuleCode = parentPosition.getRuleCode();
        } else {
            children = this.positionRepository.findByParentCodeIsNull(tenantCode);
        }
        if (!CollectionUtils.isEmpty(children)) {
            childrenDto = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(children, PositionEntity.class, TreeDto.class, HashSet.class, ArrayList.class, new String[0]));
        }
        Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Validate.notNull((Object)treeRuleCodeStrategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565", (Object[])new Object[0]);
        return treeRuleCodeStrategy.generate(6, parentRuleCode, (List)childrenDto);
    }

    private void createValidation(PositionDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setId(null);
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dto.getPositionName()) ? 1 : 0) != 0, (String)"\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getPositionName().length() < 128 ? 1 : 0) != 0, (String)"\u804c\u4f4d\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getPositionCode()) || dto.getPositionCode().length() < 64 ? 1 : 0) != 0, (String)"\u804c\u4f4d\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void updateValidation(PositionDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dto.getPositionName()) ? 1 : 0) != 0, (String)"\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getPositionName().length() < 128 ? 1 : 0) != 0, (String)"\u804c\u4f4d\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

