package com.biz.crm.mdm.business.position.local.deprecated.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.position.local.service.PositionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 旧版MDM-职位管理
 *
 * @author ning.zhang
 * @date 2021/10/14
 */
@Slf4j
@RestController
@RequestMapping("/mdmPositionController")
@Api(tags = "旧版MDM-职位管理")
@Deprecated
public class MdmPositionController {

  @Autowired(required = false)
  private PositionService positionService;

  @ApiOperation(value = "删除", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  public Result<?> delete(@RequestBody List<String> ids) {
    try {
      positionService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "启用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      positionService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "禁用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      positionService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
