package com.biz.crm.mdm.business.position.local.service;

import com.biz.crm.mdm.business.position.local.entity.PositionRoleEntity;

import java.util.List;

/**
 * 职位-角色关联表接口
 *
 * @author ning.zhang
 * @date 2021/10/12
 */
public interface PositionRoleService {

  /**
   * 通过职位编码获取职位角色列表
   *
   * @param positionCode 职位编码
   * @return 职位角色列表
   */
  List<PositionRoleEntity> findByPositionCode(String positionCode);

  /**
   * 通过职位编码集合获取职位角色列表
   *
   * @param positionCodes 职位编码集合
   * @return 职位角色列表
   */
  List<PositionRoleEntity> findByPositionCodes(List<String> positionCodes);

  /**
   * 批量移除职位关联的角色
   *
   * @param positionCodes 职位编码集合
   */
  void unbindByPositionCodes(List<String> positionCodes);

  /**
   * 添加职位关联的角色
   *
   * @param positionCode 职位编码
   * @param roleCodes    角色编码集合
   */
  void bindByPositionCodeAndRoleCodes(String positionCode, List<String> roleCodes);

  /**
   * 通过角色编码集合获取职位角色关联实体列表
   *
   * @param roleCodes 角色编码集合
   * @return 职位角色关联实体列表
   */
  List<PositionRoleEntity> findByRoleCodes(List<String> roleCodes);

  /**
   * 通过职位编码集合和职位编码绑定职位角色关联关系
   *
   * @param positionCodes 职位编码集合
   * @param roleCode    角色编码集合
   */
  void bindByPositionCodesAndRoleCode(List<String> positionCodes, String roleCode);

  /**
   * 通过职位编码集合和职位编码解绑职位角色关联关系
   *
   * @param positionCodes 职位编码集合
   * @param roleCode    角色编码集合
   */
  void unbindByPositionCodesAndRoleCode(List<String> positionCodes, String roleCode);
}
