/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.position.local.entity.PositionEntity;
import com.biz.crm.mdm.business.position.local.service.PositionRoleService;
import com.biz.crm.mdm.business.position.local.service.PositionService;
import com.biz.crm.mdm.business.position.sdk.dto.BindPositionRoleDto;
import com.biz.crm.mdm.business.position.sdk.dto.PositionDto;
import com.biz.crm.mdm.business.position.sdk.dto.RebindParentPositionDto;
import com.biz.crm.mdm.business.position.sdk.dto.UnbindPositionRoleDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/position/position"})
@Api(tags={"\u804c\u4f4d\u7ba1\u7406: Position: \u804c\u4f4d\u4fe1\u606f"})
public class PositionController {
    private static final Logger log = LoggerFactory.getLogger(PositionController.class);
    @Autowired(required=false)
    private PositionService positionService;
    @Autowired(required=false)
    private PositionRoleService positionRoleService;

    @ApiOperation(value="\u65b0\u589e\u804c\u4f4d")
    @PostMapping(value={"/create"})
    public Result<PositionEntity> create(@RequestBody PositionDto dto) {
        try {
            return Result.ok((Object)((Object)this.positionService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u804c\u4f4d")
    @PatchMapping(value={"/update"})
    public Result<PositionEntity> update(@RequestBody PositionDto dto) {
        try {
            return Result.ok((Object)((Object)this.positionService.update(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.positionService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result<?> enableBatch(@RequestBody List<String> ids) {
        try {
            this.positionService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result<?> disableBatch(@RequestBody List<String> ids) {
        try {
            this.positionService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u964d\u7ef4\u7f16\u7801")
    @PatchMapping(value={"/updateRuleCode"})
    public Result<?> updateRuleCode() {
        try {
            this.positionService.updateRuleCode();
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ed1\u5b9a\u89d2\u8272")
    @PatchMapping(value={"/bindRole"})
    public Result<?> bindRole(@RequestBody BindPositionRoleDto dto) {
        try {
            this.positionRoleService.bindByPositionCodesAndRoleCode(dto.getPositionCodeList(), dto.getRoleCode());
            return Result.ok((String)"\u7ed1\u5b9a\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u89e3\u7ed1\u89d2\u8272")
    @PatchMapping(value={"/unbindRole"})
    public Result<?> unbindRole(@RequestBody UnbindPositionRoleDto dto) {
        try {
            this.positionRoleService.unbindByPositionCodesAndRoleCode(dto.getPositionCodeList(), dto.getRoleCode());
            return Result.ok((String)"\u89e3\u7ed1\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u91cd\u7ed1\u4e0a\u7ea7\u804c\u4f4d")
    @PatchMapping(value={"/rebindParentPosition"})
    public Result<?> rebindParentPosition(@RequestBody RebindParentPositionDto dto) {
        try {
            this.positionService.rebindParentPosition(dto);
            return Result.ok((String)"\u91cd\u7ed1\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

