/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.position.local.entity.PositionRoleEntity;
import com.biz.crm.mdm.business.position.local.repository.PositionRoleRepository;
import com.biz.crm.mdm.business.position.local.service.PositionRoleService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PositionRoleServiceImpl
implements PositionRoleService {
    @Autowired(required=false)
    private PositionRoleRepository positionRoleRepository;
    @Autowired(required=false)
    private RoleVoCacheService roleVoCacheService;

    @Override
    public List<PositionRoleEntity> findByPositionCode(String positionCode) {
        if (StringUtils.isEmpty((CharSequence)positionCode)) {
            return Lists.newArrayList();
        }
        return this.positionRoleRepository.findByPositionCode(positionCode, TenantUtils.getTenantCode());
    }

    @Override
    public List<PositionRoleEntity> findByPositionCodes(List<String> positionCodes) {
        if (CollectionUtils.isEmpty(positionCodes)) {
            return Lists.newArrayList();
        }
        return this.positionRoleRepository.findByPositionCodes(positionCodes, TenantUtils.getTenantCode());
    }

    @Override
    public void unbindByPositionCodes(List<String> positionCodes) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(positionCodes), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List<PositionRoleEntity> entities = this.positionRoleRepository.findByPositionCodes(positionCodes, tenantCode);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.positionRoleRepository.deleteByPositionCodes(positionCodes, tenantCode);
        entities.forEach(entity -> this.roleVoCacheService.clearCache(tenantCode, entity.getRoleCode()));
    }

    @Override
    public void bindByPositionCodeAndRoleCodes(String positionCode, List<String> roleCodes) {
        Validate.notBlank((CharSequence)positionCode, (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(roleCodes)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List roleEntities = roleCodes.stream().map(roleCode -> {
            PositionRoleEntity entity = new PositionRoleEntity();
            entity.setRoleCode((String)roleCode);
            entity.setPositionCode(positionCode);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(roleEntities)) {
            this.positionRoleRepository.saveBatch(roleEntities);
            roleCodes.forEach(roleCode -> this.roleVoCacheService.clearCache(tenantCode, roleCode));
        }
    }

    @Override
    public List<PositionRoleEntity> findByRoleCodes(List<String> roleCodes) {
        if (CollectionUtils.isEmpty(roleCodes)) {
            return Lists.newArrayList();
        }
        return this.positionRoleRepository.findByRoleCodes(roleCodes, TenantUtils.getTenantCode());
    }

    @Override
    public void bindByPositionCodesAndRoleCode(List<String> positionCodes, String roleCode) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(positionCodes), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)roleCode, (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List<PositionRoleEntity> list = this.positionRoleRepository.findByPositionCodesAndRoleCode(positionCodes, roleCode, tenantCode);
        if (CollectionUtils.isNotEmpty(list)) {
            List existPositionCodes = list.stream().map(PositionRoleEntity::getPositionCode).collect(Collectors.toList());
            positionCodes = positionCodes.stream().filter(s -> !existPositionCodes.contains(s)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(positionCodes)) {
            return;
        }
        List entities = positionCodes.stream().map(positionCode -> {
            PositionRoleEntity entity = new PositionRoleEntity();
            entity.setTenantCode(tenantCode);
            entity.setRoleCode(roleCode);
            entity.setPositionCode((String)positionCode);
            return entity;
        }).collect(Collectors.toList());
        this.positionRoleRepository.saveBatch(entities);
    }

    @Override
    public void unbindByPositionCodesAndRoleCode(List<String> positionCodes, String roleCode) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(positionCodes), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)roleCode, (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801", (Object[])new Object[0]);
        List<PositionRoleEntity> list = this.positionRoleRepository.findByPositionCodesAndRoleCode(positionCodes, roleCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List positionRoleIds = list.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.positionRoleRepository.removeByIds(positionRoleIds);
    }
}

