/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.local.service.internal;

import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.position.local.entity.PositionEntity;
import com.biz.crm.mdm.business.position.local.entity.PositionRoleEntity;
import com.biz.crm.mdm.business.position.local.repository.PositionRepository;
import com.biz.crm.mdm.business.position.local.service.PositionRoleService;
import com.biz.crm.mdm.business.position.local.service.PositionService;
import com.biz.crm.mdm.business.position.sdk.dto.PositionDto;
import com.biz.crm.mdm.business.position.sdk.event.PositionEventListener;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PositionVoServiceImpl
implements PositionVoService {
    @Autowired(required=false)
    @Lazy
    private List<PositionEventListener> listeners;
    @Autowired(required=false)
    private PositionService positionService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private PositionRoleService positionRoleService;
    @Autowired(required=false)
    private PositionRepository positionRepository;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

    public List<PositionVo> findByIdsOrCodes(List<String> ids, List<String> positionCodes) {
        if (CollectionUtils.isEmpty(positionCodes) && CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<PositionEntity> list = this.positionService.findByIdsOrCodes(ids, positionCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return this.convertEntityToVo(list);
    }

    public List<PositionVo> findByLotPositionCodes(List<String> positionCodes) {
        return this.findByIdsOrCodes(Lists.newArrayList(), positionCodes);
    }

    public List<PositionVo> findDetailsByIdsOrCodes(List<String> ids, List<String> positionCodes) {
        if (CollectionUtils.isEmpty(positionCodes) && CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<PositionVo> list = this.findByIdsOrCodes(ids, positionCodes);
        if (!CollectionUtils.isEmpty(list)) {
            this.buildRelationData(list);
        }
        return list;
    }

    public List<PositionVo> findAllChildrenByCode(String positionCode) {
        if (StringUtils.isBlank((CharSequence)positionCode)) {
            return Lists.newArrayList();
        }
        List<PositionEntity> entities = this.positionService.findByIdsOrCodes(null, Lists.newArrayList((Object[])new String[]{positionCode}));
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        List<PositionEntity> childrenList = this.positionService.findAllChildrenByRuleCode(entities.get(0).getRuleCode());
        if (CollectionUtils.isEmpty(childrenList)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenList, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<PositionVo> findByParentCode(String positionCode) {
        if (StringUtils.isBlank((CharSequence)positionCode)) {
            return Lists.newArrayList();
        }
        List<PositionEntity> entities = this.positionRepository.findByParentCode(positionCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public PositionVo create(PositionDto dto) {
        PositionEntity entity = this.positionService.create(dto);
        if (entity == null) {
            return null;
        }
        return (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public PositionVo update(PositionDto dto) {
        PositionEntity entity = this.positionService.update(dto);
        if (entity == null) {
            return null;
        }
        return (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public PositionVo findByPositionCode(String positionCode) {
        PositionEntity entity = this.positionService.findByPositionCode(positionCode);
        if (entity == null) {
            return null;
        }
        return (PositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<PositionVo> findAllParentByRoleCodes(List<String> roleCodes) {
        if (CollectionUtils.isEmpty(roleCodes)) {
            return Lists.newLinkedList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        List<PositionEntity> entities = this.positionRepository.findByRoleCodes(roleCodes, tenantCode);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        List ruleCodes = entities.stream().map(TenantFlagTreeOpEntity::getRuleCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Set parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(6, ruleCodes);
        List<PositionEntity> parentEntities = this.positionRepository.findByRuleCodesAndEnableStatus(Lists.newArrayList((Iterable)parentRuleCodes), null, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(parentEntities)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(parentEntities, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<PositionVo> findPositionsByRoleCodes(List<String> roleCodes) {
        if (CollectionUtils.isEmpty(roleCodes)) {
            return Lists.newLinkedList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        List<PositionEntity> entities = this.positionRepository.findByRoleCodes(roleCodes, tenantCode);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Set<String> findPositionCodesByPositionLevelCodes(List<String> positionLevelCodes) {
        if (CollectionUtils.isEmpty(positionLevelCodes)) {
            return new HashSet<String>();
        }
        List<PositionEntity> byPositionLevelCodes = this.positionRepository.findByPositionLevelCodes(positionLevelCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(byPositionLevelCodes)) {
            return new HashSet<String>();
        }
        return byPositionLevelCodes.stream().map(PositionEntity::getPositionCode).collect(Collectors.toSet());
    }

    public Set<String> findRolesByPositionCodes(List<String> positionCodes) {
        if (CollectionUtils.isEmpty(positionCodes)) {
            return new HashSet<String>(0);
        }
        List<PositionRoleEntity> byPositionCodes = this.positionRoleService.findByPositionCodes(positionCodes);
        if (CollectionUtils.isEmpty(byPositionCodes)) {
            return new HashSet<String>(0);
        }
        return byPositionCodes.stream().map(PositionRoleEntity::getRoleCode).collect(Collectors.toSet());
    }

    public List<PositionVo> findAllParentByPositionCode(String positionCode) {
        return this.findParent(positionCode, true);
    }

    public List<PositionVo> findParentByPositionCode(String positionCode) {
        return this.findParent(positionCode, false);
    }

    private List<PositionVo> findParent(String positionCode, Boolean isAll) {
        if (StringUtils.isBlank((CharSequence)positionCode) || ObjectUtils.isEmpty((Object)isAll)) {
            return new ArrayList<PositionVo>();
        }
        ArrayList<String> allRuleCodeList = new ArrayList<String>();
        PositionEntity byPositionCode = this.positionService.findByPositionCode(positionCode);
        if (ObjectUtils.isEmpty((Object)((Object)byPositionCode))) {
            return new ArrayList<PositionVo>();
        }
        String ruleCode = byPositionCode.getRuleCode();
        int length = ruleCode.length();
        int positionRuleCodeLength = 6;
        if (isAll.booleanValue()) {
            int count = length / positionRuleCodeLength;
            for (int i = 1; i <= count; ++i) {
                String substring = ruleCode.substring(0, positionRuleCodeLength * i);
                allRuleCodeList.add(substring);
            }
        } else {
            String substring = ruleCode.substring(0, length - positionRuleCodeLength);
            allRuleCodeList.add(substring);
        }
        List<PositionEntity> byRuleCodesAndEnableStatus = this.positionRepository.findByRuleCodesAndEnableStatus(allRuleCodeList, EnableStatusEnum.ENABLE.getCode(), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(byRuleCodesAndEnableStatus)) {
            return new ArrayList<PositionVo>(0);
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(byRuleCodesAndEnableStatus, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private List<PositionVo> convertEntityToVo(List<PositionEntity> entities) {
        ArrayList list = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]));
        List<PositionRoleEntity> positionRoles = this.positionRoleService.findByPositionCodes(list.stream().map(PositionVo::getPositionCode).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(positionRoles)) {
            Map positionRoleMap = positionRoles.stream().collect(Collectors.groupingBy(PositionRoleEntity::getPositionCode, Collectors.mapping(PositionRoleEntity::getRoleCode, Collectors.toList())));
            list.forEach(positionVo -> positionVo.setRoleList((List)positionRoleMap.get(positionVo.getPositionCode())));
        }
        return list;
    }

    private void buildRelationData(List<PositionVo> list) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(this.listeners)) {
            return;
        }
        List positionCodes = list.stream().map(PositionVo::getPositionCode).collect(Collectors.toList());
        ArrayList relationList = Lists.newArrayList();
        for (PositionEventListener positionEventListener : this.listeners) {
            List dataList = positionEventListener.onRequestByPositionCodes(positionCodes);
            if (CollectionUtils.isEmpty((Collection)dataList)) continue;
            relationList.addAll(dataList);
        }
        if (!CollectionUtils.isEmpty((Collection)relationList)) {
            Map<String, List<PositionRelationVo>> relationMap = relationList.stream().collect(Collectors.groupingBy(PositionRelationVo::getPositionCode));
            list.forEach(positionVo -> positionVo.setRelationData((List)relationMap.get(positionVo.getPositionCode())));
        }
    }
}

