package com.biz.crm.mdm.business.position.local.authority;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * @Author: heguanyun
 * @Date: 2022/4/7 16:49 description:
 */
@Component("positionScopeRegister")
public class PositionScopeRegister implements SelectScopeRegister {
  @Override
  public String scopeKey() {
    return "position_scope";
  }

  @Override
  public String selectName() {
    return "职位";
  }

  @Override
  public String controlKey() {
    return "position";
  }

  @Override
  public String controlName() {
    return "职位";
  }

  @Override
  public boolean matched(UserIdentity loginDetails, String[] scopeValues) {
    if (scopeValues == null || scopeValues.length == 0) {
      return false;
    }
    // 如果不是后台管理用户，就不按职位进行权限控制
    String identityType = loginDetails.getIdentityType();
    if (!StringUtils.equals(identityType, "u")) {
      return false;
    }
    AbstractCrmUserIdentity loginUserDetails = (AbstractCrmUserIdentity) loginDetails;
    Set<String> scopeSet = new HashSet<>(Arrays.asList(scopeValues));
    return scopeSet.contains(loginUserDetails.getPostCode());
  }
}
