package com.biz.crm.mdm.business.position.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.mdm.business.position.local.entity.PositionEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 职位的mybatis-plus接口类 {@link PositionEntity}
 *
 * @author ning.zhang
 * @date 2021/9/29
 */
public interface PositionMapper extends BaseMapper<PositionEntity> {

  /**
   * 更具降维编码集合查询所有子级职位列表
   *
   * @param ruleCodes  降维编码集合
   * @param enableStatus     启用状态
   * @param tenantCode   租户编码
   * @return 所有子级职位列表
   */
  List<PositionEntity> findCurAndChildrenByRuleCodes(@Param("ruleCodes") List<String> ruleCodes
      , @Param("enableStatus") String enableStatus
      , @Param("tenantCode") String tenantCode);

  /**
   * 将parentCode不为空但找不到对应上级的数据,设置parentCode为null
   *
   * @param tenantCode   租户编码
   */
  void updateOrphanParentCodeNull(@Param("tenantCode") String tenantCode);

  /**
   * 通过角色编码集合获取职位信息
   * @param roleCodes 角色编码集合
   * @param tenantCode 租户编码
   * @return 职位实体集合
   */
  List<PositionEntity> findByRoleCodes(@Param("roleCodes") List<String> roleCodes,@Param("tenantCode") String tenantCode);
}
