package com.biz.crm.mdm.business.position.local.service.notifier;

import com.biz.crm.mdm.business.position.local.entity.PositionEntity;
import com.biz.crm.mdm.business.position.local.service.PositionService;
import com.biz.crm.mdm.business.position.level.sdk.event.PositionLevelEventListener;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 职位监听职级变更事件
 *
 * @author ning.zhang
 * @date 2021/10/9
 */
@Component
public class PositionLevelEventListenerImpl implements PositionLevelEventListener {

  @Autowired(required = false)
  private PositionService positionService;

  @Override
  public void onCreate(PositionLevelVo vo) {
    //do nothing
  }

  @Override
  public void onUpdate(PositionLevelVo oldVo, PositionLevelVo newVo) {
    //do nothing
  }

  @Override
  public void onDisable(List<PositionLevelVo> voList) {
    //do nothing
  }

  @Override
  public void onEnable(List<PositionLevelVo> voList) {
    //do nothing
  }

  /**
   * 当职位级别发生删除事件时，根据触发事件的职位级别信息中的职位级别编码,验证职位级别是否存在与职位的关联关系。
   *
   * 1.存在与职位的关联关系,则抛出职位级别已关联职位的异常,阻断当前职位级别的删除操作
   * 2.不存在与职位的关联关系,则什么也不做.
   */
  @Override
  public void onDelete(List<PositionLevelVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    Map<String, PositionLevelVo> positionLevelMap = voList.stream().collect(Collectors.toMap(PositionLevelVo::getPositionLevelCode, t -> t));
    List<PositionEntity> positionEntities = positionService.findByPositionLevelCodes(Lists.newArrayList(positionLevelMap.keySet()));
    if (CollectionUtils.isNotEmpty(positionEntities)) {
      throw new IllegalArgumentException("职位级别" + positionLevelMap.get(positionEntities.get(0).getPositionLevelCode()).getPositionLevelName()
          + "已经关联了职位，不能删除");
    }
  }
}
