package com.biz.crm.mdm.business.position.local.service.notifier;

import com.biz.crm.mdm.business.position.local.entity.PositionEntity;
import com.biz.crm.mdm.business.position.local.service.PositionService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.sdk.event.RoleEventListener;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * 职位级别监听角色事件
 *
 * @author ning.zhang
 * @date 2021/10/18
 */
@Component
public class PositionRoleEventListenerImpl implements RoleEventListener {

  @Autowired(required = false)
  private PositionService positionService;


  @Override
  public void onCreated(RoleVo role) {
    //do nothing
  }

  @Override
  public void onUpdate(RoleVo role) {
    //do nothing
  }

  /**
   * 当角色发生删除事件时，根据触发事件的角色信息中的角色编码,验证角色是否存在与职位的关联关系。
   * <p>
   * 1.存在与职位的关联关系,则抛出角色已关联职位的异常,阻断当前角色的删除操作
   * 2.不存在与职位的关联关系,则什么也不做.
   */
  @Override
  public void onDeleted(RoleVo role) {
    if (Objects.isNull(role) || StringUtils.isBlank(role.getRoleCode())) {
      return;
    }
    List<PositionEntity> entities = this.positionService.findByRoleCodes(Lists.newArrayList(role.getRoleCode()), TenantUtils.getTenantCode());
    Validate.isTrue(CollectionUtils.isEmpty(entities), "角色" + role.getRoleName() + "已经关联了职位，不能删除");
  }


}
