package com.biz.crm.mdm.business.position.local.service.notifier;

import com.biz.crm.mdm.business.position.local.entity.PositionEntity;
import com.biz.crm.mdm.business.position.local.service.PositionService;
import com.biz.crm.mdm.business.position.sdk.constant.PositionConstant;
import com.bizunited.nebula.rbac.sdk.event.RoleUpRelationRegister;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 角色向上关联职位信息
 *
 * @author ning.zhang
 * @date 2021/10/30
 */
@Component
public class PositionRoleUpRelationRegisterImpl implements RoleUpRelationRegister {

  @Autowired(required = false)
  private PositionService positionService;

  @Override
  public String moduleName() {
    return PositionConstant.POSITION_MODULE_NAME;
  }

  /**
   * 当角色发生第三方业务模块关联数据查询时。
   * 返回和这个roleCode绑定的职位编码集合
   */
  @Override
  public List<String> onRequestUserAccount(String roleCode, String tenantCode) {
    if (StringUtils.isAnyBlank(roleCode, tenantCode)) {
      return Lists.newArrayList();
    }
    List<PositionEntity> entities = this.positionService.findByRoleCodes(Lists.newArrayList(roleCode), tenantCode);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newArrayList();
    }
    return entities.stream().map(PositionEntity::getPositionLevelCode).collect(Collectors.toList());
  }
}
