package com.biz.crm.mdm.business.position.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 职位-角色关联实体
 *
 * @author ning.zhang
 * @date 2021/10/13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PositionRoleEntity", description = "职位-角色关联表实体")
@Entity
@TableName("mdm_position_role")
@Table(name = "mdm_position_role", indexes = {
    @Index(name = "mdm_position_role_index1", columnList = "position_code"),
    @Index(name = "mdm_position_role_index2", columnList = "role_code"),
    @Index(name = "mdm_position_role_index3", columnList = "tenant_code,position_code,role_code",unique = true)
})
@org.hibernate.annotations.Table(appliesTo = "mdm_position_role", comment = "职位-角色关联表")
public class PositionRoleEntity extends TenantEntity {

  private static final long serialVersionUID = -212229065718443145L;

  /**
   * 职位编码
   */
  @ApiModelProperty(name = "position_code", value = "职位编码", required = true)
  @Column(name = "position_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '职位编码'")
  private String positionCode;

  /**
   * 角色编码
   */
  @ApiModelProperty(name = "role_code", value = "角色编码", required = true)
  @Column(name = "role_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '角色编码'")
  private String roleCode;

}
