/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.position.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.position.local.entity.PositionRoleEntity;
import com.biz.crm.mdm.business.position.local.mapper.PositionRoleMapper;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class PositionRoleRepository
extends ServiceImpl<PositionRoleMapper, PositionRoleEntity> {
    public List<PositionRoleEntity> findByPositionCode(String positionCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(PositionRoleEntity::getPositionCode, (Object)positionCode)).list();
    }

    public List<PositionRoleEntity> findByPositionCodes(List<String> positionCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(PositionRoleEntity::getPositionCode, positionCodes)).list();
    }

    public void deleteByPositionCodes(List<String> positionCodes, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(PositionRoleEntity::getPositionCode, positionCodes)).remove();
    }

    public List<PositionRoleEntity> findByPositionCodeAndRoleCodes(String positionCode, List<String> roleCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)super.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(PositionRoleEntity::getPositionCode, (Object)positionCode)).in(PositionRoleEntity::getRoleCode, roleCodes)).list();
    }

    public List<PositionRoleEntity> findByRoleCodes(List<String> roleCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)super.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(PositionRoleEntity::getRoleCode, roleCodes)).list();
    }

    public List<PositionRoleEntity> findByPositionCodesAndRoleCode(List<String> positionCodes, String roleCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(PositionRoleEntity::getPositionCode, positionCodes)).eq(PositionRoleEntity::getRoleCode, (Object)roleCode)).list();
    }

    public void removeByIdsAndTenantCode(List<String> positionRoleIds, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, positionRoleIds)).remove();
    }
}

