package com.biz.crm.mdm.business.position.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 绑定职位角色Dto
 *
 * @author ning.zhang
 * @date 2021/11/11
 */
@Data
@ApiModel(value = "BindPositionRoleDto", description = "绑定职位角色Dto")
public class BindPositionRoleDto {

  /**
   * 角色编码
   */
  @ApiModelProperty("角色编码")
  private String roleCode;

  /**
   * 职位编码集合
   */
  @ApiModelProperty("职位编码集合")
  private List<String> positionCodeList;

  /**
   * 角色编码集合，新增职位需要关联角色的时候传这个
   */
  @ApiModelProperty("角色编码集合，新增职位需要关联角色的时候传这个")
  private List<PositionRoleDto> positionRoles;

}