package com.biz.crm.mdm.business.position.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.List;

/**
 * 职位dto
 *
 * @author ning.zhang
 * @date 2021/10/12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位dto", description = "职位")
public class PositionDto extends TenantDto {

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;
  /**
   * MDG职位编码
   */
  @ApiModelProperty(name = "mdg_position_code", value = "MDG职位编码", required = true)
  private String mdgPositionCode;
  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;
  /**
   * 上级职位编码
   */
  @ApiModelProperty("上级职位编码")
  private String parentCode;
  /**
   * 职位级别编码
   */
  @ApiModelProperty("职位级别编码")
  private String positionLevelCode;
  /**
   * 职位来源[数据字典:mdm_position_source]
   */
  @ApiModelProperty(name = "position_source", value = "职位来源[数据字典:mdm_position_source]")
  private String positionSource;
  /**
   * MDG职位名称生成TPM职位名称后缀增长序列号（同一个mdg编码只有一条有数据）
   */
  @ApiModelProperty(name = "suffix_sequence", value = "MDG职位名称生成TPM职位名称后缀增长序列号（同一个mdg编码只有一条有数据）")
  private Integer suffixSequence;
  /**
   * 启禁用
   */
  @ApiModelProperty("启禁用")
  private String enableStatus;
  /**
   * 角色编码集合，新增职位需要关联角色的时候传这个
   */
  @ApiModelProperty("角色编码集合，新增职位需要关联角色的时候传这个")
  private List<String> roleCodeList;

  /**
   * 角色编码集合，新增职位需要关联角色的时候传这个
   */
  @ApiModelProperty("角色编码集合，新增职位需要关联角色的时候传这个")
  private List<PositionRoleDto> positionRoles;

  /**
   * 关联上级模块数据信息(如关联的组织)
   */
  @ApiModelProperty("关联上级模块数据信息(如关联的组织)")
  private List<PositionRelationDto> relationData;
}