package com.biz.crm.mdm.business.position.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.Date;

import static org.apache.ibatis.type.JdbcType.VARCHAR;

/**
 * @author : rentao
 * @date : 2023/3/16 11:32
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位关联角色dto", description = "职位关联角色dto")
public class PositionRoleDto extends TenantDto {

  /**
   * 职位编码
   */
  @ApiModelProperty(name = "position_code", value = "职位编码", required = true)
  private String positionCode;

  /**
   * 角色编码
   */
  @ApiModelProperty(name = "role_code", value = "角色编码", required = true)
  private String roleCode;

  /**
   * 角色名称
   */
  @ApiModelProperty(name = "role_name", value = "角色名称")
  private String roleName;

  /**
   * 有效期限
   */
  @ApiModelProperty(name = "indate_type", value = "有效期限")
  private String indateType;

  /** 生效时间 */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("生效时间")
  private Date startTime;

  /** 失效时间 */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("失效时间")
  private Date endTime;

  /**
   * 备注
   */
  @TableField(value = "remark", jdbcType = VARCHAR)
  private String remark;

}
