package com.biz.crm.mdm.business.position.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author : rentao
 * @date : 2023/3/16 15:39
 */
public enum IndateTypeEnum {


  /**
   * 编码与描述
   */
  LONG_TIME("long_time", "long_time", "长期有效", "1"),
  CUSTOMIZE_TIME("customize_time", "customize_time", "范围有效", "2");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  IndateTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  public String getDictCode() {
    return dictCode;
  }

  /**
   * 通过key获取 IndateTypeEnum
   *
   * @param key
   * @return
   */
  public static IndateTypeEnum getByKey(String key) {
    return Arrays.stream(IndateTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 IndateTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static IndateTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(IndateTypeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
            .findFirst().orElse(null);
  }

  /**
   * 通过value获取 IndateTypeEnum
   *
   * @param value
   * @return
   */
  public static IndateTypeEnum getByValue(String value) {
    return Arrays.stream(IndateTypeEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
            .findFirst().orElse(null);
  }
}
