package com.biz.crm.mdm.business.position.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantTreeFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.List;

/**
 * 职位VO
 *
 * @author ning.zhang
 * @date 2021/10/13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位表")
public class PositionVo extends TenantTreeFlagOpVo {

    private static final long serialVersionUID = 7281844844093831468L;
    /**
     * 职位编码
     */
    @ApiModelProperty("职位编码")
    private String positionCode;
    /**
     * MDG职位编码
     */
    @ApiModelProperty(name = "mdg_position_code", value = "MDG职位编码", required = true)
    private String mdgPositionCode;
    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    private String positionName;
    /**
     * 上级职位编码
     */
    @ApiModelProperty("上级职位编码")
    private String parentCode;
    /**
     * 职位级别编码
     */
    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;
    /**
     * 职位来源[数据字典:mdm_position_source]
     */
    @ApiModelProperty(name = "position_source", value = "职位来源[数据字典:mdm_position_source]")
    private String positionSource;
    /**
     * MDG职位名称生成TPM职位名称后缀增长序列号（同一个mdg编码只有一条有数据）
     */
    @ApiModelProperty(name = "suffix_sequence", value = "MDG职位名称生成TPM职位名称后缀增长序列号（同一个mdg编码只有一条有数据）")
    private Integer suffixSequence;
    /**
     * 关联角色编码
     */
    @ApiModelProperty("关联角色编码")
    private List<String> roleList;

    /**
     * 角色集合，新增职位需要关联角色的时候传这个 支持蒙牛
     */
    @ApiModelProperty("角色集合，新增职位需要关联角色的时候传这个")
    private List<PositionRoleVo> positionRoles;

    /**
     * 关联数据
     */
    @ApiModelProperty("关联数据")
    private List<PositionRelationVo> relationData;
}