package com.biz.crm.mdm.business.position.sdk.event;

import com.biz.crm.mdm.business.position.sdk.vo.PositionEventVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationVo;

import java.util.List;

/**
 * 职位信息变更事件通知接口
 *
 * @author ning.zhang
 * @date 2021/9/30
 */
public interface PositionEventListener {

  /**
   * 当职位创建时触发
   *
   * @param vo 创建时的vo
   */
  void onCreate(PositionEventVo vo);

  /**
   * 当职位修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  void onUpdate(PositionEventVo oldVo, PositionEventVo newVo);

  /**
   * 当职位禁用时触发
   *
   * @param voList 禁用vo信息
   */
  void onDisable(List<PositionEventVo> voList);

  /**
   * 当职位启用时触发
   *
   * @param voList 禁用vo信息
   */
  void onEnable(List<PositionEventVo> voList);

  /**
   * 当职位删除时触发
   *
   * @param voList 删除vo信息
   */
  void onDelete(List<PositionEventVo> voList);

  /**
   * 根据职位编码集合获取附加信息
   * @param positionCodes 职位编码集合
   * @return 附加信息列表
   */
  List<PositionRelationVo> onRequestByPositionCodes(List<String> positionCodes);
}
