package com.biz.crm.mdm.business.position.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 职位事件Vo
 *
 * @author ning.zhang
 * @date 2021/10/12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位事件Vo", description = "职位")
public class PositionEventVo extends TenantVo {

  private static final long serialVersionUID = 5549587973075743476L;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;
  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;
  /**
   * 上级职位编码
   */
  @ApiModelProperty("上级职位编码")
  private String parentCode;
  /**
   * 职位级别编码
   */
  @ApiModelProperty("职位级别编码")
  private String positionLevelCode;
  /**
   * 角色编码集合
   */
  @ApiModelProperty("角色编码集合")
  private List<String> roleCodeList;

  /**
   * 关联上级模块数据信息(如关联的组织)
   */
  @ApiModelProperty("关联上级模块数据信息(如关联的组织)")
  private List<PositionRelationEventVo> relationData;
}