package com.biz.crm.mdm.business.position.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantTreeFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 职位VO
 *
 * @author ning.zhang
 * @date 2021/10/13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位表")
public class PositionVo extends TenantTreeFlagOpVo {

    private static final long serialVersionUID = 7281844844093831468L;
    /**
     * 职位编码
     */
    @ApiModelProperty("职位编码")
    private String positionCode;
    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    private String positionName;
    /**
     * 上级职位编码
     */
    @ApiModelProperty("上级职位编码")
    private String parentCode;
    /**
     * 职位级别编码
     */
    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;
    /**
     * 关联角色编码
     */
    @ApiModelProperty("关联角色编码")
    private List<String> roleList;
    /**
     * 关联数据
     */
    @ApiModelProperty("关联数据")
    private List<PositionRelationVo> relationData;
}