package com.biz.crm.mdm.business.price.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.price.feign.feign.internal.PriceModelVoServiceFeignImpl;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import java.util.Map;
import java.util.Set;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 价格管理feign
 *
 * @author sunx
 * @date 2022/1/6
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = PriceModelVoServiceFeignImpl.class)
public interface PriceModelVoServiceFeign {

  /**
   * 查询价格
   *
   * @param dto
   * @return
   */
  @PostMapping(value = {"/v1/price/price/handleSearchPrice"})
  Result<Map<String, PriceModelVo>> handleSearchPrice(@RequestBody SearchPriceDto dto);

  /**
   * 获取产品红线价
   * @param productCodeSet
   * @author jiangyin
   * @date 2023/3/15 9:55
   * @return com.biz.crm.business.common.sdk.model.Result<java.util.Map<java.lang.String,com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo>>
   */
  @PostMapping(value = {"/v1/price/price/findRedLinePriceByProductCodeList"})
  Result<Map<String, PriceModelVo>> findRedLinePriceByProductCodeList(@RequestBody Set<String> productCodeSet);
}
