package com.biz.crm.mdm.business.price.feign.service.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.price.feign.feign.PriceModelVoServiceFeign;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Set;

/**
 * 询价sdk接口实现
 *
 * @author sunx
 * @date 2022/1/6
 */
@Service
public class PriceModelVoServiceImpl implements PriceModelVoService {

  @Autowired(required = false) private PriceModelVoServiceFeign priceModelVoServiceFeign;

  @Override
  public Map<String, PriceModelVo> handleSearchPrice(SearchPriceDto dto) {
    Result<Map<String, PriceModelVo>> result = this.priceModelVoServiceFeign.handleSearchPrice(dto);
    Validate.isTrue(result.isSuccess(), result.getMessage());
    return result.getResult();
  }
  
  @Override
  public Map<String, PriceModelVo> findRedLinePriceByProductCodeList(Set<String> productCodeSet){
    return this.priceModelVoServiceFeign.findRedLinePriceByProductCodeList(productCodeSet).getResult();
  }

}
