package com.biz.crm.mdm.business.price.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.price.feign.feign.PriceModelVoServiceFeign;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import java.util.Map;
import org.springframework.stereotype.Component;

/**
 * 价格管理feign实现
 *
 * @author sunx
 * @date 2022/1/6
 */
@Component
public class PriceModelVoServiceFeignImpl implements FallbackFactory<PriceModelVoServiceFeign> {

  @Override
  public PriceModelVoServiceFeign create(Throwable throwable) {

    return new PriceModelVoServiceFeign() {
      @Override
      public Result<Map<String, PriceModelVo>> handleSearchPrice(SearchPriceDto dto) {
        throw new UnsupportedOperationException("查询价格熔断");
      }

      @Override
      public Result<Map<String, PriceModelVo>> findPrice(FindPriceDto dto) {
        throw new UnsupportedOperationException("询价熔断");
      }

      @Override
      public Result<Map<String, PriceModelVo>> findBusinessPrice(FindBusinessPriceDto dto) {
        throw new UnsupportedOperationException("询价熔断");
      }
    };
  }
}
