package com.biz.crm.mdm.business.price.feign.service.internal;

import com.biz.crm.mdm.business.price.feign.feign.PriceModelVoServiceFeign;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 询价sdk接口实现
 *
 * @author sunx
 * @date 2022/1/6
 */
@Service
public class PriceModelVoServiceImpl implements PriceModelVoService {

  @Autowired(required = false) private PriceModelVoServiceFeign priceModelVoServiceFeign;

  @Override
  public Map<String, PriceModelVo> handleSearchPrice(SearchPriceDto dto) {
    return this.priceModelVoServiceFeign.handleSearchPrice(dto).getResult();
  }

  @Override
  public Map<String, PriceModelVo> findPrice(FindPriceDto dto) {
    return this.priceModelVoServiceFeign.findPrice(dto).getResult();
  }

  @Override
  public Map<String, PriceModelVo> findBusinessPrice(FindBusinessPriceDto dto) {
    return this.priceModelVoServiceFeign.findBusinessPrice(dto).getResult();
  }
}
